"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetProcessor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../../../../../shared_imports");
var _utils = require("../../../utils");
var _shared = require("./shared");
var _field_name_field = require("./common_fields/field_name_field");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Optional fields config
const fieldsConfig = {
  mediaType: {
    type: _shared_imports.FIELD_TYPES.SELECT,
    defaultValue: 'application/json',
    serializer: _shared.from.undefinedIfValue('application/json'),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.setForm.mediaTypeFieldLabel', {
      defaultMessage: 'Media Type'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.setForm.mediaTypeHelpText",
      defaultMessage: "Media type for encoding value."
    })
  },
  override: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: true,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(true),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.setForm.overrideFieldLabel', {
      defaultMessage: 'Override'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.setForm.overrideFieldHelpText",
      defaultMessage: "If enabled, overwrite existing field values. If disabled, only update {nullValue} fields.",
      values: {
        nullValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'null')
      }
    })
  },
  ignore_empty_value: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: false,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(false),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.setForm.ignoreEmptyValueFieldLabel', {
      defaultMessage: 'Ignore empty value'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.setForm.ignoreEmptyValueFieldHelpText",
      defaultMessage: "If {valueField} is {nullValue} or an empty string, do not update the field.",
      values: {
        valueField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'value'),
        nullValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'null')
      }
    })
  }
};

// Required fields config
const getValueConfig = toggleCustom => ({
  value: {
    path: 'fields.value',
    euiFieldProps: {
      'data-test-subj': 'valueFieldInput'
    },
    config: {
      type: _shared_imports.FIELD_TYPES.TEXT,
      serializer: _shared.from.emptyStringToUndefined,
      label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.setForm.valueFieldLabel', {
        defaultMessage: 'Value'
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.pipelineEditor.setForm.valueFieldHelpText",
        defaultMessage: "Value for the field."
      }),
      fieldsToValidateOnChange: ['fields.value', 'fields.copy_from'],
      validations: [{
        validator: ({
          value,
          path,
          formData
        }) => {
          if ((0, _lodash.isEmpty)(value) && (0, _lodash.isEmpty)(formData['fields.copy_from'])) {
            return {
              path,
              message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.requiredValue', {
                defaultMessage: 'A value is required.'
              })
            };
          }
        }
      }]
    },
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: toggleCustom,
      "data-test-subj": "toggleCustomField"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.useCopyFromLabel",
      defaultMessage: "Use copy from field"
    }))),
    key: 'value'
  },
  copy_from: {
    path: 'fields.copy_from',
    euiFieldProps: {
      'data-test-subj': 'copyFromInput'
    },
    config: {
      type: _shared_imports.FIELD_TYPES.TEXT,
      serializer: _shared.from.emptyStringToUndefined,
      fieldsToValidateOnChange: ['fields.value', 'fields.copy_from'],
      validations: [{
        validator: ({
          value,
          path,
          formData
        }) => {
          if ((0, _lodash.isEmpty)(value) && (0, _lodash.isEmpty)(formData['fields.value'])) {
            return {
              path,
              message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.requiredCopyFrom', {
                defaultMessage: 'A copy from value is required.'
              })
            };
          }
        }
      }],
      label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.setForm.copyFromFieldLabel', {
        defaultMessage: 'Copy from'
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.pipelineEditor.setForm.copyFromFieldHelpText",
        defaultMessage: "Field to copy into {field}.",
        values: {
          field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'Field')
        }
      })
    },
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: toggleCustom,
      "data-test-subj": "toggleCustomField"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.useValueLabel",
      defaultMessage: "Use value field"
    }))),
    key: 'copy_from'
  }
});

/**
 * Disambiguate name from the Set data structure
 */
const SetProcessor = () => {
  const {
    getFieldDefaultValue
  } = (0, _shared_imports.useFormContext)();
  const [{
    fields
  }] = (0, _shared_imports.useFormData)({
    watch: ['fields.value', 'fields.copy_from']
  });
  const isCopyFromDefined = getFieldDefaultValue('fields.copy_from') !== undefined;
  const [isCopyFromEnabled, setIsCopyFrom] = (0, _react.useState)(isCopyFromDefined);
  const toggleCustom = (0, _react.useCallback)(() => {
    setIsCopyFrom(prev => !prev);
  }, []);
  const valueFieldProps = (0, _react.useMemo)(() => isCopyFromEnabled ? getValueConfig(toggleCustom).copy_from : getValueConfig(toggleCustom).value, [isCopyFromEnabled, toggleCustom]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.setForm.fieldNameField', {
      defaultMessage: 'Field to insert or update.'
    })
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, (0, _extends2.default)({}, valueFieldProps, {
    component: _shared_imports.Field
  })), (0, _utils.hasTemplateSnippet)(fields === null || fields === void 0 ? void 0 : fields.value) && /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'mediaTypeSelectorField',
        options: [{
          value: 'application/json',
          text: 'application/json'
        }, {
          value: 'text/plain',
          text: 'text/plain'
        }, {
          value: 'application/x-www-form-urlencoded',
          text: 'application/x-www-form-urlencoded'
        }]
      }
    },
    config: fieldsConfig.mediaType,
    component: _shared_imports.SelectField,
    path: "fields.media_type"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.override,
    component: _shared_imports.ToggleField,
    path: "fields.override",
    "data-test-subj": "overrideField"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.ignore_empty_value,
    component: _shared_imports.ToggleField,
    path: "fields.ignore_empty_value",
    "data-test-subj": "ignoreEmptyField"
  }));
};
exports.SetProcessor = SetProcessor;