"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XJsonEditor = void 0;
var _monaco = require("@kbn/monaco");
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../../../shared_imports");
var _text_editor = require("./text_editor");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  useXJsonMode
} = _shared_imports.XJson;
const defaultEditorOptions = {
  minimap: {
    enabled: false
  },
  lineNumbers: 'off'
};
const XJsonEditor = ({
  field,
  editorProps
}) => {
  const {
    value,
    setValue
  } = field;
  const {
    xJson,
    setXJson,
    convertToJson
  } = useXJsonMode(value);
  const onChange = (0, _react.useCallback)(s => {
    setXJson(s);
    setValue(convertToJson(s));
  }, [setValue, setXJson, convertToJson]);
  return /*#__PURE__*/_react.default.createElement(_text_editor.TextEditor, {
    field: field,
    editorProps: {
      value: xJson,
      languageId: _monaco.XJsonLang.ID,
      options: defaultEditorOptions,
      onChange,
      ...editorProps
    }
  });
};
exports.XJsonEditor = XJsonEditor;