"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineProcessorsItemTooltip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
require("./pipeline_processors_editor_item_toolip.scss");
var _processor_information = require("./processor_information");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MOUSE_PADDING_RIGHT = 20;
const MOUSE_PADDING_BOTTOM = 20;
const PipelineProcessorsItemTooltip = ({
  processor
}) => {
  const [position, setPosition] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const mouseMoveListener = event => {
      setPosition({
        x: event.pageX,
        y: event.pageY - window.scrollY
      });
    };
    document.addEventListener('mousemove', mouseMoveListener);
    return () => {
      document.removeEventListener('mousemove', mouseMoveListener);
    };
  }, []);
  if (!position) {
    return null;
  }
  return (
    /*#__PURE__*/
    /**
     * To get around issues with parent elements potentially being position: relative or
     * overflow: hidden we use a portal to render this tooltip in the document body so
     * that we can render it anywhere the cursor can go.
     */
    _react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "pipelineProcessorsEditor__itemTooltip",
      style: {
        left: position.x + MOUSE_PADDING_RIGHT,
        top: position.y + MOUSE_PADDING_BOTTOM
      }
    }, /*#__PURE__*/_react.default.createElement(_processor_information.ProcessorInformation, {
      processor: processor
    })))
  );
};
exports.PipelineProcessorsItemTooltip = PipelineProcessorsItemTooltip;