"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inventoryViewSavedObjectType = exports.inventoryViewSavedObjectName = void 0;
var _Either = require("fp-ts/lib/Either");
var _pipeable = require("fp-ts/lib/pipeable");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inventoryViewSavedObjectName = exports.inventoryViewSavedObjectName = 'inventory-view';
const getInventoryViewTitle = savedObject => (0, _pipeable.pipe)(_types.inventoryViewSavedObjectRT.decode(savedObject), (0, _Either.fold)(() => `Inventory view [id=${savedObject.id}]`, ({
  attributes: {
    name
  }
}) => name));
const inventoryViewSavedObjectType = exports.inventoryViewSavedObjectType = {
  name: inventoryViewSavedObjectName,
  hidden: false,
  namespaceType: 'single',
  management: {
    defaultSearchField: 'name',
    displayName: 'inventory view',
    getTitle: getInventoryViewTitle,
    icon: 'metricsApp',
    importableAndExportable: true
  },
  mappings: {
    dynamic: false,
    properties: {}
  }
};