"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInventoryModelAggregations = exports.createFilters = void 0;
var _common = require("@kbn/metrics-data-access-plugin/common");
var _server = require("@kbn/observability-plugin/server");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createFilters = ({
  params,
  extraFilter,
  hostNamesShortList = []
}) => {
  var _extraFilter$bool;
  const extrafilterClause = extraFilter === null || extraFilter === void 0 ? void 0 : (_extraFilter$bool = extraFilter.bool) === null || _extraFilter$bool === void 0 ? void 0 : _extraFilter$bool.filter;
  const extraFilterList = !!extrafilterClause ? Array.isArray(extrafilterClause) ? extrafilterClause : [extrafilterClause] : [];
  return [...extraFilterList, ...(0, _server.termsQuery)(_constants.BUCKET_KEY, ...hostNamesShortList), ...(0, _server.rangeQuery)(new Date(params.range.from).getTime(), new Date(params.range.to).getTime()), {
    exists: {
      field: _constants.BUCKET_KEY
    }
  }];
};
exports.createFilters = createFilters;
const getInventoryModelAggregations = (assetType, metrics) => {
  const inventoryModel = (0, _common.findInventoryModel)(assetType);
  return metrics.reduce((acc, metric) => {
    var _inventoryModel$metri;
    return (_inventoryModel$metri = inventoryModel.metrics.snapshot) !== null && _inventoryModel$metri !== void 0 && _inventoryModel$metri[metric] ? Object.assign(acc, inventoryModel.metrics.snapshot[metric]) : acc;
  }, {});
};
exports.getInventoryModelAggregations = getInventoryModelAggregations;