"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInfraMetricsClient = getInfraMetricsClient;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getInfraMetricsClient({
  sourceId,
  framework,
  infraSources,
  requestContext,
  request
}) {
  const soClient = (await requestContext.core).savedObjects.getClient();
  const source = await infraSources.getSourceConfiguration(soClient, sourceId);
  return {
    search(searchParams) {
      return framework.callWithRequest(requestContext, 'search', {
        ...searchParams,
        index: source.configuration.metricAlias
      }, request);
    }
  };
}