"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRate = exports.isMetricRate = exports.isInterfaceRateAgg = exports.isCustomMetricRate = void 0;
var _lodash = require("lodash");
var _common = require("@kbn/metrics-data-access-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isMetricRate = metric => {
  if (!_common.MetricsUIAggregationRT.is(metric)) {
    return false;
  }
  const values = Object.values(metric);
  return values.some(agg => _common.ESDerivativeAggRT.is(agg)) && values.some(agg => _common.ESBasicMetricAggRT.is(agg) && (0, _lodash.has)(agg, 'max'));
};
exports.isMetricRate = isMetricRate;
const isCustomMetricRate = customMetric => {
  return customMetric.aggregation === 'rate';
};
exports.isCustomMetricRate = isCustomMetricRate;
const isInterfaceRateAgg = metric => {
  if (!_common.MetricsUIAggregationRT.is(metric)) {
    return false;
  }
  const values = Object.values(metric);
  return values.some(agg => _common.ESTermsWithAggregationRT.is(agg)) && values.some(agg => _common.ESSumBucketAggRT.is(agg));
};
exports.isInterfaceRateAgg = isInterfaceRateAgg;
const isRate = (metric, customMetric) => {
  return isMetricRate(metric) || isInterfaceRateAgg(metric) || customMetric && isCustomMetricRate(customMetric);
};
exports.isRate = isRate;