"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.globalizeSelectors = exports.globalizeSelector = exports.bindPlainActionCreators = void 0;
var _redux = require("redux");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Selectors
 */

const globalizeSelector = (globalizer, selector) => globalState => selector(globalizer(globalState));
exports.globalizeSelector = globalizeSelector;
const globalizeSelectors = (globalizer, selectors) => {
  const globalSelectors = {};
  for (const s in selectors) {
    if (selectors.hasOwnProperty(s)) {
      globalSelectors[s] = globalizeSelector(globalizer, selectors[s]);
    }
  }
  return globalSelectors;
};

/**
 * Action Creators
 */
exports.globalizeSelectors = globalizeSelectors;
const bindPlainActionCreators = actionCreators => dispatch => (0, _redux.bindActionCreators)(actionCreators, dispatch);
exports.bindPlainActionCreators = bindPlainActionCreators;