"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/observability-plugin/public");
var _common = require("@kbn/observability-shared-plugin/common");
var _rxjs = require("rxjs");
var _presentationContainers = require("@kbn/presentation-containers");
var _public3 = require("@kbn/ui-actions-plugin/public");
var _public4 = require("@kbn/embeddable-plugin/public");
var _inventory = require("./alerting/inventory");
var _log_threshold = require("./alerting/log_threshold");
var _metric_threshold = require("./alerting/metric_threshold");
var _constants = require("./components/log_stream/constants");
var _locators = require("../common/locators");
var _metrics_overview_fetchers = require("./metrics_overview_fetchers");
var _register_feature = require("./register_feature");
var _inventory_views = require("./services/inventory_views");
var _metrics_explorer_views = require("./services/metrics_explorer_views");
var _telemetry = require("./services/telemetry");
var _logs_overview_fetchers = require("./utils/logs_overview_fetchers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class Plugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "inventoryViews", void 0);
    (0, _defineProperty2.default)(this, "metricsExplorerViews", void 0);
    (0, _defineProperty2.default)(this, "telemetry", void 0);
    (0, _defineProperty2.default)(this, "locators", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "isServerlessEnv", void 0);
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.BehaviorSubject(() => ({})));
    this.config = context.config.get();
    this.inventoryViews = new _inventory_views.InventoryViewsService();
    this.metricsExplorerViews = this.config.featureFlags.metricsExplorerEnabled ? new _metrics_explorer_views.MetricsExplorerViewsService() : undefined;
    this.telemetry = new _telemetry.TelemetryService();
    this.kibanaVersion = context.env.packageInfo.version;
    this.isServerlessEnv = context.env.packageInfo.buildFlavor === 'serverless';
  }
  setup(core, pluginsSetup) {
    var _this$config$sources, _this$config$sources$, _this$config$sources$2;
    if (pluginsSetup.home) {
      (0, _register_feature.registerFeatures)(pluginsSetup.home);
    }
    pluginsSetup.uiActions.registerTrigger({
      id: _common.ObservabilityTriggerId.LogEntryContextMenu
    });
    pluginsSetup.observability.observabilityRuleTypeRegistry.register((0, _inventory.createInventoryMetricRuleType)());
    pluginsSetup.observability.observabilityRuleTypeRegistry.register((0, _metric_threshold.createMetricThresholdRuleType)());
    if (this.config.featureFlags.logsUIEnabled) {
      // fetchData `appLink` redirects to logs/stream
      pluginsSetup.observability.dashboard.register({
        appName: 'infra_logs',
        hasData: (0, _logs_overview_fetchers.getLogsHasDataFetcher)(core.getStartServices),
        fetchData: (0, _logs_overview_fetchers.getLogsOverviewDataFetcher)(core.getStartServices)
      });
    }
    pluginsSetup.observability.dashboard.register({
      appName: 'infra_metrics',
      hasData: (0, _metrics_overview_fetchers.createMetricsHasData)(core.getStartServices),
      fetchData: (0, _metrics_overview_fetchers.createMetricsFetchData)(core.getStartServices)
    });
    pluginsSetup.logsShared.logViews.setLogViewsStaticConfig({
      messageFields: (_this$config$sources = this.config.sources) === null || _this$config$sources === void 0 ? void 0 : (_this$config$sources$ = _this$config$sources.default) === null || _this$config$sources$ === void 0 ? void 0 : (_this$config$sources$2 = _this$config$sources$.fields) === null || _this$config$sources$2 === void 0 ? void 0 : _this$config$sources$2.message
    });
    const startDep$AndHostViewFlag$ = (0, _rxjs.combineLatest)([(0, _rxjs.from)(core.getStartServices()), core.settings.client.get$(_public2.enableInfrastructureHostsView)]);

    /** !! Need to be kept in sync with the deepLinks in x-pack/plugins/observability_solution/infra/public/plugin.ts */
    pluginsSetup.observabilityShared.navigation.registerSections(startDep$AndHostViewFlag$.pipe((0, _rxjs.map)(([[{
      application: {
        capabilities
      }
    }], isInfrastructureHostsViewEnabled]) => {
      return [...(capabilities.logs.show ? [{
        label: 'Logs',
        sortKey: 200,
        entries: [{
          label: 'Explorer',
          app: 'observability-logs-explorer',
          path: '/',
          isBetaFeature: true
        }, ...(this.config.featureFlags.logsUIEnabled ? [{
          label: 'Stream',
          app: 'logs',
          path: '/stream'
        }, {
          label: 'Anomalies',
          app: 'logs',
          path: '/anomalies'
        }, {
          label: 'Categories',
          app: 'logs',
          path: '/log-categories'
        }] : [])]
      }] : []), ...(capabilities.infrastructure.show ? [{
        label: 'Infrastructure',
        sortKey: 300,
        entries: [{
          label: 'Inventory',
          app: 'metrics',
          path: '/inventory'
        }, ...(this.config.featureFlags.metricsExplorerEnabled ? [{
          label: 'Metrics Explorer',
          app: 'metrics',
          path: '/explorer'
        }] : []), ...(isInfrastructureHostsViewEnabled ? [{
          label: 'Hosts',
          isBetaFeature: true,
          app: 'metrics',
          path: '/hosts'
        }] : [])]
      }] : [])];
    })));
    pluginsSetup.embeddable.registerReactEmbeddableFactory(_constants.LOG_STREAM_EMBEDDABLE, async () => {
      const {
        getLogStreamEmbeddableFactory
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./components/log_stream/log_stream_react_embeddable')));
      const [coreStart, pluginDeps, pluginStart] = await core.getStartServices();
      return getLogStreamEmbeddableFactory({
        coreStart,
        pluginDeps,
        pluginStart
      });
    });

    // Register Locators
    const logsLocator = this.config.featureFlags.logsUIEnabled ? pluginsSetup.share.url.locators.create(new _locators.InfraLogsLocatorDefinition({
      core
    })) : undefined;
    const nodeLogsLocator = this.config.featureFlags.logsUIEnabled ? pluginsSetup.share.url.locators.create(new _locators.InfraNodeLogsLocatorDefinition({
      core
    })) : undefined;
    pluginsSetup.observability.observabilityRuleTypeRegistry.register((0, _log_threshold.createLogThresholdRuleType)(core, pluginsSetup.share.url));
    if (this.config.featureFlags.logsUIEnabled) {
      core.application.register({
        id: 'logs',
        title: _i18n.i18n.translate('xpack.infra.logs.pluginTitle', {
          defaultMessage: 'Logs'
        }),
        euiIconType: 'logoObservability',
        order: 8100,
        appRoute: '/app/logs',
        // !! Need to be kept in sync with the routes in x-pack/plugins/observability_solution/infra/public/pages/logs/page_content.tsx
        deepLinks: [{
          id: 'stream',
          title: _i18n.i18n.translate('xpack.infra.logs.index.streamTabTitle', {
            defaultMessage: 'Stream'
          }),
          path: '/stream'
        }, {
          id: 'anomalies',
          title: _i18n.i18n.translate('xpack.infra.logs.index.anomaliesTabTitle', {
            defaultMessage: 'Anomalies'
          }),
          path: '/anomalies'
        }, {
          id: 'log-categories',
          title: _i18n.i18n.translate('xpack.infra.logs.index.logCategoriesBetaBadgeTitle', {
            defaultMessage: 'Categories'
          }),
          path: '/log-categories'
        }, {
          id: 'settings',
          title: _i18n.i18n.translate('xpack.infra.logs.index.settingsTabTitle', {
            defaultMessage: 'Settings'
          }),
          path: '/settings'
        }],
        category: _public.DEFAULT_APP_CATEGORIES.observability,
        mount: async params => {
          // mount callback should not use setup dependencies, get start dependencies instead
          const [coreStart, plugins, pluginStart] = await core.getStartServices();
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./apps/logs_app')));
          return renderApp(coreStart, plugins, pluginStart, params);
        }
      });
    }

    // !! Need to be kept in sync with the routes in x-pack/plugins/observability_solution/infra/public/pages/metrics/index.tsx
    const getInfraDeepLinks = ({
      hostsEnabled,
      metricsExplorerEnabled
    }) => {
      const visibleIn = ['globalSearch'];
      return [{
        id: 'inventory',
        title: _i18n.i18n.translate('xpack.infra.homePage.inventoryTabTitle', {
          defaultMessage: 'Inventory'
        }),
        path: '/inventory',
        visibleIn
      }, ...(hostsEnabled ? [{
        id: 'hosts',
        title: _i18n.i18n.translate('xpack.infra.homePage.metricsHostsTabTitle', {
          defaultMessage: 'Hosts'
        }),
        path: '/hosts',
        visibleIn
      }] : []), ...(metricsExplorerEnabled ? [{
        id: 'metrics-explorer',
        title: _i18n.i18n.translate('xpack.infra.homePage.metricsExplorerTabTitle', {
          defaultMessage: 'Metrics Explorer'
        }),
        path: '/explorer'
      }] : []), {
        id: 'settings',
        title: _i18n.i18n.translate('xpack.infra.homePage.settingsTabTitle', {
          defaultMessage: 'Settings'
        }),
        path: '/settings'
      }, {
        id: 'assetDetails',
        title: '',
        // Internal deep link, not shown in the UI. Title is dynamically set in the app.
        path: '/detail',
        visibleIn: []
      }];
    };
    core.application.register({
      id: 'metrics',
      title: _i18n.i18n.translate('xpack.infra.metrics.pluginTitle', {
        defaultMessage: 'Infrastructure'
      }),
      euiIconType: 'logoObservability',
      order: 8200,
      appRoute: '/app/metrics',
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      updater$: this.appUpdater$,
      deepLinks: getInfraDeepLinks({
        hostsEnabled: core.settings.client.get(_public2.enableInfrastructureHostsView),
        metricsExplorerEnabled: this.config.featureFlags.metricsExplorerEnabled
      }),
      mount: async params => {
        var _pluginsSetup$cloud, _pluginsSetup$cloud2;
        // mount callback should not use setup dependencies, get start dependencies instead
        const [coreStart, plugins, pluginStart] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./apps/metrics_app')));
        const isCloudEnv = !!((_pluginsSetup$cloud = pluginsSetup.cloud) !== null && _pluginsSetup$cloud !== void 0 && _pluginsSetup$cloud.isCloudEnabled);
        const isServerlessEnv = ((_pluginsSetup$cloud2 = pluginsSetup.cloud) === null || _pluginsSetup$cloud2 === void 0 ? void 0 : _pluginsSetup$cloud2.isServerlessEnabled) || this.isServerlessEnv;
        return renderApp(coreStart, {
          ...plugins,
          licenseManagement: pluginsSetup.licenseManagement
        }, pluginStart, this.config, params, {
          kibanaVersion: this.kibanaVersion,
          isCloudEnv,
          isServerlessEnv
        });
      }
    });

    /* This exists purely to facilitate URL redirects from the old App ID ("infra"),
    to our new App IDs ("metrics" and "logs"). With version 8.0.0 we can remove this. */
    core.application.register({
      id: 'infra',
      appRoute: '/app/infra',
      title: 'infra',
      visibleIn: [],
      mount: async params => {
        const [coreStart] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./apps/legacy_app')));
        return renderApp(coreStart, params);
      }
    });
    startDep$AndHostViewFlag$.subscribe(([_startServices, isInfrastructureHostsViewEnabled]) => {
      this.appUpdater$.next(() => ({
        deepLinks: getInfraDeepLinks({
          hostsEnabled: isInfrastructureHostsViewEnabled,
          metricsExplorerEnabled: this.config.featureFlags.metricsExplorerEnabled
        })
      }));
    });

    // Setup telemetry events
    this.telemetry.setup({
      analytics: core.analytics
    });
    this.locators = {
      logsLocator,
      nodeLogsLocator
    };
    return {
      locators: this.locators
    };
  }
  start(core, plugins) {
    var _this$metricsExplorer;
    const inventoryViews = this.inventoryViews.start({
      http: core.http
    });
    const metricsExplorerViews = (_this$metricsExplorer = this.metricsExplorerViews) === null || _this$metricsExplorer === void 0 ? void 0 : _this$metricsExplorer.start({
      http: core.http
    });
    const telemetry = this.telemetry.start();
    plugins.uiActions.registerAction({
      id: _constants.ADD_LOG_STREAM_ACTION_ID,
      grouping: [_public4.COMMON_EMBEDDABLE_GROUPING.legacy],
      order: 30,
      getDisplayName: () => _i18n.i18n.translate('xpack.infra.logStreamEmbeddable.displayName', {
        defaultMessage: 'Log stream (deprecated)'
      }),
      getDisplayNameTooltip: () => _i18n.i18n.translate('xpack.infra.logStreamEmbeddable.description', {
        defaultMessage: 'Add a table of live streaming logs. For a more efficient experience, we recommend using the Discover Page to create a saved search instead of using Log stream.'
      }),
      getIconType: () => 'logsApp',
      isCompatible: async ({
        embeddable
      }) => {
        return (0, _presentationContainers.apiCanAddNewPanel)(embeddable);
      },
      execute: async ({
        embeddable
      }) => {
        if (!(0, _presentationContainers.apiCanAddNewPanel)(embeddable)) throw new _public3.IncompatibleActionError();
        embeddable.addNewPanel({
          panelType: _constants.LOG_STREAM_EMBEDDABLE,
          initialState: {
            title: _i18n.i18n.translate('xpack.infra.logStreamEmbeddable.title', {
              defaultMessage: 'Log stream'
            })
          }
        }, true);
      }
    });
    plugins.uiActions.attachAction(_public3.ADD_PANEL_TRIGGER, _constants.ADD_LOG_STREAM_ACTION_ID);
    const startContract = {
      inventoryViews,
      metricsExplorerViews,
      telemetry,
      locators: this.locators
    };
    return startContract;
  }
  stop() {}
}
exports.Plugin = Plugin;