"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeaturesConfigurationPanel = FeaturesConfigurationPanel;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _managementSettingsComponentsFieldRow = require("@kbn/management-settings-components-field-row");
var _use_kibana = require("../../../hooks/use_kibana");
var _plugin_config_context = require("../../../containers/plugin_config_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LazyFieldRow = /*#__PURE__*/_react.default.lazy(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/management-settings-components-field-row')))).FieldRow
}));
const FieldRow = (0, _sharedUxUtility.withSuspense)(LazyFieldRow);
function FeaturesConfigurationPanel({
  readOnly,
  handleFieldChange,
  fields,
  unsavedChanges
}) {
  const {
    services: {
      docLinks,
      notifications
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    featureFlags
  } = (0, _plugin_config_context.usePluginConfig)();

  // We don't validate the user input on these settings
  const settingsValidationResponse = {
    successfulValidation: true,
    valid: true
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "sourceConfigurationFeaturesSectionTitle"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.featuresSectionTitle",
    defaultMessage: "Features"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRowProvider, {
    links: docLinks.links.management,
    showDanger: message => notifications.toasts.addDanger(message),
    validateChange: async () => settingsValidationResponse
  }, /*#__PURE__*/_react.default.createElement(FieldRow, {
    field: fields[_common.enableInfrastructureHostsView],
    isSavingEnabled: true,
    onFieldChange: handleFieldChange,
    unsavedChange: unsavedChanges[_common.enableInfrastructureHostsView]
  }), /*#__PURE__*/_react.default.createElement(FieldRow, {
    field: fields[_common.enableInfrastructureAssetCustomDashboards],
    isSavingEnabled: true,
    onFieldChange: handleFieldChange,
    unsavedChange: unsavedChanges[_common.enableInfrastructureAssetCustomDashboards]
  }), featureFlags.profilingEnabled && /*#__PURE__*/_react.default.createElement(FieldRow, {
    field: fields[_common.enableInfrastructureProfilingIntegration],
    isSavingEnabled: true,
    onFieldChange: handleFieldChange,
    unsavedChange: unsavedChanges[_common.enableInfrastructureProfilingIntegration]
  }), /*#__PURE__*/_react.default.createElement(FieldRow, {
    field: fields[_common.enableInfrastructureContainerAssetView],
    isSavingEnabled: true,
    onFieldChange: handleFieldChange,
    unsavedChange: unsavedChanges[_common.enableInfrastructureContainerAssetView]
  })));
}