"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerPage = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _with_metrics_explorer_options_url_state = require("../../../containers/metrics_explorer/with_metrics_explorer_options_url_state");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_metrics_explorer_views = require("../../../hooks/use_metrics_explorer_views");
var _use_metrics_breadcrumbs = require("../../../hooks/use_metrics_breadcrumbs");
var _empty_states = require("../../../components/empty_states");
var _charts = require("./components/charts");
var _toolbar = require("./components/toolbar");
var _use_metric_explorer_state = require("./hooks/use_metric_explorer_state");
var _page_template = require("../page_template");
var _translations = require("../../../translations");
var _saved_views = require("./components/saved_views");
var _use_metrics_explorer_options = require("./hooks/use_metrics_explorer_options");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METRICS_EXPLORER_FEEDBACK_URL = 'https://ela.st/survey-infra-metricsexplorer?usp=pp_url';
const MetricsExplorerPage = () => {
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'metrics_explorer'
  });
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'metrics_explorer',
    delay: 15000
  });
  (0, _use_metrics_breadcrumbs.useMetricsBreadcrumbs)([{
    text: _translations.metricsExplorerTitle
  }]);
  return /*#__PURE__*/_react.default.createElement(_use_metrics_explorer_options.MetricsExplorerOptionsContainer, null, /*#__PURE__*/_react.default.createElement(_with_metrics_explorer_options_url_state.WithMetricsExplorerOptionsUrlState, null), /*#__PURE__*/_react.default.createElement(MetricsExplorerContent, null));
};
exports.MetricsExplorerPage = MetricsExplorerPage;
const MetricsExplorerContent = () => {
  const [enabled, setEnabled] = (0, _react.useState)(false);
  const {
    isLoading,
    error,
    data,
    timeRange,
    options,
    chartOptions,
    setChartOptions,
    handleAggregationChange,
    handleMetricsChange,
    handleFilterQuerySubmit,
    handleGroupByChange,
    handleTimeChange,
    handleLoadMore,
    onViewStateChange,
    refresh
  } = (0, _use_metric_explorer_state.useMetricsExplorerState)({
    enabled
  });
  const {
    currentView
  } = (0, _use_metrics_explorer_views.useMetricsExplorerViews)();
  const {
    kibanaVersion,
    isCloudEnv,
    isServerlessEnv
  } = (0, _use_kibana.useKibanaEnvironmentContext)();
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'metrics_explorer'
  });
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'metrics_explorer',
    delay: 15000
  });
  (0, _react.useEffect)(() => {
    if (currentView) {
      onViewStateChange(currentView);
    }
  }, [currentView, onViewStateChange]);
  (0, _react.useEffect)(() => {
    if (currentView != null) {
      // load metrics explorer data after default view loaded, unless we're not isLoading a view
      setEnabled(true);
    }
  }, [currentView]);
  (0, _use_metrics_breadcrumbs.useMetricsBreadcrumbs)([{
    text: _translations.metricsExplorerTitle
  }]);
  const viewState = {
    options,
    chartOptions,
    currentTimerange: timeRange
  };
  return /*#__PURE__*/_react.default.createElement(_page_template.MetricsPageTemplate, {
    pageHeader: {
      pageTitle: _translations.metricsExplorerTitle,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_saved_views.SavedViews, {
        viewState: viewState
      }), /*#__PURE__*/_react.default.createElement(_public.FeatureFeedbackButton, {
        formUrl: METRICS_EXPLORER_FEEDBACK_URL,
        "data-test-subj": "infraMetricsExplorerFeedbackLink",
        kibanaVersion: kibanaVersion,
        isCloudEnv: isCloudEnv,
        isServerlessEnv: isServerlessEnv
      })]
    }
  }, /*#__PURE__*/_react.default.createElement(_toolbar.MetricsExplorerToolbar, {
    timeRange: timeRange,
    options: options,
    chartOptions: chartOptions,
    onRefresh: refresh,
    onTimeChange: handleTimeChange,
    onGroupByChange: handleGroupByChange,
    onFilterQuerySubmit: handleFilterQuerySubmit,
    onMetricsChange: handleMetricsChange,
    onAggregationChange: handleAggregationChange,
    onChartOptionsChange: setChartOptions
  }), error ? /*#__PURE__*/_react.default.createElement(_empty_states.NoData, {
    titleText: "Whoops!",
    bodyText: _i18n.i18n.translate('xpack.infra.metricsExplorer.errorMessage', {
      defaultMessage: 'It looks like the request failed with "{message}"',
      values: {
        message: error.message
      }
    }),
    onRefetch: refresh,
    refetchText: "Try Again"
  }) : /*#__PURE__*/_react.default.createElement(_charts.MetricsExplorerCharts, {
    timeRange: timeRange,
    isLoading: isLoading,
    data: data,
    options: options,
    chartOptions: chartOptions,
    onLoadMore: handleLoadMore,
    onFilter: handleFilterQuerySubmit,
    onRefetch: refresh,
    onTimeChange: handleTimeChange
  }));
};