"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerGroupBy = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _metrics_source = require("../../../../containers/metrics_source");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsExplorerGroupBy = ({
  options,
  onChange,
  errorOptions
}) => {
  var _metricsView$fields;
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const handleChange = (0, _react.useCallback)(selectedOptions => {
    const groupBy = selectedOptions.map(option => option.label);
    onChange(groupBy);
  }, [onChange]);
  const selectedOptions = Array.isArray(options.groupBy) ? options.groupBy.map(field => ({
    label: field,
    color: errorOptions !== null && errorOptions !== void 0 && errorOptions.includes(field) ? 'danger' : undefined
  })) : options.groupBy ? [{
    label: options.groupBy,
    color: errorOptions !== null && errorOptions !== void 0 && errorOptions.includes(options.groupBy) ? 'danger' : undefined
  }] : [];
  const comboOptions = ((_metricsView$fields = metricsView === null || metricsView === void 0 ? void 0 : metricsView.fields) !== null && _metricsView$fields !== void 0 ? _metricsView$fields : []).filter(f => f.aggregatable && f.type === 'string').map(f => ({
    label: f.name
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "metricsExplorer-groupBy",
    placeholder: _i18n.i18n.translate('xpack.infra.metricsExplorer.groupByLabel', {
      defaultMessage: 'Everything'
    }),
    "aria-label": _i18n.i18n.translate('xpack.infra.metricsExplorer.groupByAriaLabel', {
      defaultMessage: 'Graph per'
    }),
    fullWidth: true,
    singleSelection: false,
    selectedOptions: selectedOptions,
    options: comboOptions,
    onChange: handleChange,
    isClearable: true
  });
};
exports.MetricsExplorerGroupBy = MetricsExplorerGroupBy;