"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeDetailsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _use_page_header = require("../../../../components/asset_details/hooks/use_page_header");
var _use_node_details = require("../hooks/use_node_details");
var _side_nav = require("./side_nav");
var _time_controls = require("./time_controls");
var _side_nav_context = require("../lib/side_nav_context");
var _page_body = require("./page_body");
var _page_error = require("./page_error");
var _metadata_context = require("../containers/metadata_context");
var _page_template = require("../../page_template");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseRange = range => {
  const parsedFrom = _datemath.default.parse(range.from.toString());
  const parsedTo = _datemath.default.parse(range.to.toString(), {
    roundUp: true
  });
  return {
    ...range,
    from: parsedFrom && parsedFrom.valueOf() || (0, _moment.default)().subtract(1, 'hour').valueOf(),
    to: parsedTo && parsedTo.valueOf() || (0, _moment.default)().valueOf()
  };
};
const NodeDetailsPage = props => {
  const {
    breadcrumbs
  } = (0, _use_page_header.useTemplateHeaderBreadcrumbs)();
  const [parsedTimeRange, setParsedTimeRange] = (0, _react.useState)(parseRange(props.timeRange));
  const {
    metrics,
    loading,
    makeRequest,
    error
  } = (0, _use_node_details.useNodeDetails)(props.requiredMetrics, props.nodeId, props.nodeType, props.sourceId, parsedTimeRange, props.cloudId);
  const refetch = (0, _react.useCallback)(() => {
    setParsedTimeRange(parseRange(props.timeRange));
  }, [props.timeRange]);
  (0, _react.useEffect)(() => {
    setParsedTimeRange(parseRange(props.timeRange));
  }, [props.timeRange]);
  (0, _react.useEffect)(() => {
    makeRequest();
  }, [makeRequest, parsedTimeRange]);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_page_error.PageError, {
      error: error,
      name: props.name
    });
  }
  return /*#__PURE__*/_react.default.createElement(_page_template.MetricsPageTemplate, {
    pageHeader: {
      pageTitle: props.name,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_time_controls.MetricsTimeControls, {
        currentTimeRange: props.timeRange,
        isLiveStreaming: props.isAutoReloading,
        refreshInterval: props.refreshInterval,
        setRefreshInterval: props.setRefreshInterval,
        onChangeTimeRange: props.setTimeRange,
        setAutoReload: props.setAutoReload,
        onRefresh: refetch
      })],
      breadcrumbs
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_side_nav.MetricsSideNav, {
    loading: props.metadataLoading,
    name: props.name,
    items: props.sideNav
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_side_nav_context.SideNavContext.Provider, {
    value: {
      items: props.sideNav,
      addNavItem: props.addNavItem
    }
  }, /*#__PURE__*/_react.default.createElement(_metadata_context.MetadataContext.Provider, {
    value: props.metadata
  }, /*#__PURE__*/_react.default.createElement(_page_body.PageBody, {
    loading: metrics.length > 0 && props.isAutoReloading ? false : loading,
    refetch: refetch,
    type: props.nodeType,
    metrics: metrics,
    onChangeRangeTime: props.setTimeRange,
    isLiveStreaming: props.isAutoReloading,
    stopLiveStreaming: () => props.setAutoReload(false)
  }))))));
};
exports.NodeDetailsPage = NodeDetailsPage;