"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Node = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _reactHooks = require("@kbn/react-hooks");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/observability-plugin/common");
var _conditional_tooltip = require("./conditional_tooltip");
var _color_from_value = require("../../lib/color_from_value");
var _node_context_menu = require("./node_context_menu");
var _node_square = require("./node_square");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Node = ({
  nodeType,
  node,
  options,
  squareSize,
  bounds,
  formatter,
  currentTime,
  setFlyoutUrlState,
  detailsItemId
}) => {
  const [isToolTipOpen, {
    off: hideToolTip,
    on: showToolTip
  }] = (0, _reactHooks.useBoolean)(false);
  const [isPopoverOpen, {
    off: closePopover,
    toggle: togglePopover
  }] = (0, _reactHooks.useBoolean)(false);
  const metric = (0, _lodash.first)(node.metrics);
  const rawValue = metric && metric.value || 0;
  const color = (0, _color_from_value.colorFromValue)(options.legend, rawValue, bounds);
  const value = formatter(rawValue);
  const isContainerAssetViewEnabled = (0, _public.useUiSetting)(_common.enableInfrastructureContainerAssetView);
  const showContainerAssetDetailPage = nodeType === 'container' && isContainerAssetViewEnabled;
  const toggleAssetPopover = () => {
    if (nodeType === 'host' || showContainerAssetDetailPage) {
      setFlyoutUrlState({
        detailsItemId: node.id,
        assetType: nodeType
      });
    } else {
      togglePopover();
    }
  };
  const nodeSquare = /*#__PURE__*/_react.default.createElement(_node_square.NodeSquare, {
    squareSize: squareSize,
    togglePopover: toggleAssetPopover,
    showToolTip: showToolTip,
    hideToolTip: hideToolTip,
    color: color,
    nodeName: node.name,
    value: value,
    showBorder: detailsItemId === node.id || isPopoverOpen
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isPopoverOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: nodeSquare,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downCenter",
    style: {
      height: squareSize
    }
  }, /*#__PURE__*/_react.default.createElement(_node_context_menu.NodeContextMenu, {
    node: node,
    nodeType: nodeType,
    options: options,
    currentTime: currentTime
  })) : isToolTipOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "regular",
    position: "right",
    content: /*#__PURE__*/_react.default.createElement(_conditional_tooltip.ConditionalToolTip, {
      currentTime: currentTime,
      node: node,
      nodeType: nodeType
    })
  }, nodeSquare) : nodeSquare);
};
exports.Node = Node;