"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConditionalToolTip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _get_custom_metric_label = require("../../../../../../common/formatters/get_custom_metric_label");
var _metrics_source = require("../../../../../containers/metrics_source");
var _use_snaphot = require("../../hooks/use_snaphot");
var _create_inventory_metric_formatter = require("../../lib/create_inventory_metric_formatter");
var _intl_strings = require("../../../../../../common/inventory_models/intl_strings");
var _use_waffle_options = require("../../hooks/use_waffle_options");
var _create_formatter_for_metric = require("../../../metrics_explorer/components/helpers/create_formatter_for_metric");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConditionalToolTip = ({
  node,
  nodeType,
  currentTime
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    sourceId
  } = (0, _metrics_source.useSourceContext)();
  // prevents auto-refresh from cancelling ongoing requests to fetch the data for the tooltip
  const requestCurrentTime = (0, _react.useRef)(currentTime);
  const model = (0, _common.findInventoryModel)(nodeType);
  const {
    customMetrics
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const requestMetrics = model.tooltipMetrics.map(type => ({
    type
  })).concat(customMetrics);
  const query = JSON.stringify({
    bool: {
      filter: {
        match_phrase: {
          [model.fields.id]: node.id
        }
      }
    }
  });
  const {
    nodes,
    loading
  } = (0, _use_snaphot.useSnapshot)({
    filterQuery: query,
    metrics: requestMetrics,
    groupBy: [],
    nodeType,
    sourceId,
    currentTime: requestCurrentTime.current,
    accountId: '',
    region: ''
  }, {
    abortable: true
  });
  const dataNode = (0, _lodash.first)(nodes);
  const metrics = dataNode && dataNode.metrics || [];
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      minWidth: 200
    },
    "data-test-subj": `conditionalTooltipContent-${node.name}`
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      borderBottom: `${euiTheme.border.thin}`,
      borderBottomColor: `${euiTheme.colors.mediumShade}`,
      paddingBottom: euiTheme.size.xs,
      marginBottom: euiTheme.size.xs
    }
  }, node.name), loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "conditionalTooltipContent-loading"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }))) : metrics.map(metric => {
    const metricName = _common.SnapshotMetricTypeRT.is(metric.name) ? metric.name : 'custom';
    const name = _intl_strings.SNAPSHOT_METRIC_TRANSLATIONS[metricName] || metricName;
    // if custom metric, find field and label from waffleOptionsContext result
    // because useSnapshot does not return it
    const customMetric = name === 'custom' ? customMetrics.find(item => item.id === metric.name) : null;
    const formatter = customMetric ? (0, _create_formatter_for_metric.createFormatterForMetric)(customMetric) : (0, _create_inventory_metric_formatter.createInventoryMetricFormatter)({
      type: metricName
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      key: metric.name
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      className: "eui-textTruncate eui-displayBlock",
      "data-test-subj": "conditionalTooltipContent-metric"
    }, customMetric ? (0, _get_custom_metric_label.getCustomMetricLabel)(customMetric) : name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": "conditionalTooltipContent-value"
    }, metric.value && formatter(metric.value) || '-'));
  }));
};
exports.ConditionalToolTip = ConditionalToolTip;