"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostsTableContext = exports.useHostsTable = exports.HostsTableProvider = exports.HostsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constate = _interopRequireDefault(require("constate"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _lodash = require("lodash");
var _fp = require("lodash/fp");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _use_kibana = require("../../../../hooks/use_kibana");
var _create_inventory_metric_formatter = require("../../inventory_view/lib/create_inventory_metric_formatter");
var _entry_title = require("../components/table/entry_title");
var _use_hosts_table_url_state = require("./use_hosts_table_url_state");
var _use_hosts_view = require("./use_hosts_view");
var _metrics_source = require("../../../../containers/metrics_source");
var _column_header = require("../components/table/column_header");
var _translations = require("../translations");
var _visualizations = require("../../../../common/visualizations");
var _build = require("../../../../utils/filters/build");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Columns and items types
 */

/**
 * Helper functions
 */
const formatMetric = (type, value) => {
  return value || value === 0 ? (0, _create_inventory_metric_formatter.createInventoryMetricFormatter)({
    type
  })(value) : 'N/A';
};
const buildItemsList = nodes => {
  return nodes.map(({
    metrics,
    metadata,
    name,
    alertsCount
  }) => {
    var _metadataKeyValue$hos, _ref, _metadataKeyValue$hos2, _metadataKeyValue$hos3;
    const metadataKeyValue = metadata.reduce((acc, curr) => ({
      ...acc,
      [curr.name]: curr.value
    }), {});
    return {
      name,
      id: `${name}-${(_metadataKeyValue$hos = metadataKeyValue['host.os.name']) !== null && _metadataKeyValue$hos !== void 0 ? _metadataKeyValue$hos : '-'}`,
      title: {
        name,
        cloudProvider: (_ref = metadataKeyValue['cloud.provider']) !== null && _ref !== void 0 ? _ref : null
      },
      os: (_metadataKeyValue$hos2 = metadataKeyValue['host.os.name']) !== null && _metadataKeyValue$hos2 !== void 0 ? _metadataKeyValue$hos2 : '-',
      ip: (_metadataKeyValue$hos3 = metadataKeyValue['host.ip']) !== null && _metadataKeyValue$hos3 !== void 0 ? _metadataKeyValue$hos3 : '',
      ...metrics.reduce((acc, curr) => {
        var _curr$value;
        return {
          ...acc,
          [curr.name]: (_curr$value = curr.value) !== null && _curr$value !== void 0 ? _curr$value : 0
        };
      }, {}),
      alertsCount: alertsCount !== null && alertsCount !== void 0 ? alertsCount : 0
    };
  });
};
const isTitleColumn = cell => {
  return cell !== null && typeof cell === 'object' && cell && 'name' in cell;
};
const sortValues = (aValue, bValue, {
  direction
}) => {
  if (typeof aValue === 'string' && typeof bValue === 'string') {
    return direction === 'desc' ? bValue.localeCompare(aValue) : aValue.localeCompare(bValue);
  }
  if ((0, _fp.isNumber)(aValue) && (0, _fp.isNumber)(bValue)) {
    return direction === 'desc' ? bValue - aValue : aValue - bValue;
  }
  return 1;
};
const sortTableData = ({
  direction,
  field
}) => (a, b) => {
  const aValue = a[field];
  const bValue = b[field];
  if (isTitleColumn(aValue) && isTitleColumn(bValue)) {
    return sortValues(aValue.name, bValue.name, {
      direction,
      field
    });
  }
  return sortValues(aValue, bValue, {
    direction,
    field
  });
};

/**
 * Build a table columns and items starting from the snapshot nodes.
 */
const useHostsTable = () => {
  const inventoryModel = (0, _common.findInventoryModel)('host');
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const {
    hostNodes
  } = (0, _use_hosts_view.useHostsViewContext)();
  const displayAlerts = hostNodes.some(item => 'alertsCount' in item);
  const {
    value: formulas
  } = (0, _useAsync.default)(() => inventoryModel.metrics.getFormulas());
  const [{
    detailsItemId,
    pagination,
    sorting
  }, setProperties] = (0, _use_hosts_table_url_state.useHostsTableUrlState)();
  const {
    services: {
      telemetry,
      data: {
        query: {
          filterManager: filterManagerService
        }
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const closeFlyout = (0, _react.useCallback)(() => setProperties({
    detailsItemId: null
  }), [setProperties]);
  const onSelectionChange = newSelectedItems => {
    setSelectedItems(newSelectedItems);
  };
  const filterSelectedHosts = (0, _react.useCallback)(() => {
    if (!selectedItems.length) {
      return [];
    }
    const selectedHostNames = selectedItems.map(({
      name
    }) => name);
    const newFilter = (0, _build.buildCombinedAssetFilter)({
      field: _constants.HOST_NAME_FIELD,
      values: selectedHostNames,
      dataView: metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference
    });
    filterManagerService.addFilters(newFilter);
    setSelectedItems([]);
  }, [filterManagerService, metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference, selectedItems]);
  const reportHostEntryClick = (0, _react.useCallback)(({
    name,
    cloudProvider
  }) => {
    telemetry.reportHostEntryClicked({
      hostname: name,
      cloud_provider: cloudProvider
    });
  }, [telemetry]);
  const onTableChange = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    const {
      index: pageIndex,
      size: pageSize
    } = page;
    const {
      field,
      direction
    } = sort !== null && sort !== void 0 ? sort : {};
    const currentSorting = {
      field: field,
      direction
    };
    const currentPagination = {
      pageIndex,
      pageSize
    };
    if (!(0, _lodash.isEqual)(sorting, currentSorting)) {
      setProperties({
        sorting: currentSorting
      });
    } else if (!(0, _lodash.isEqual)(pagination, currentPagination)) {
      setProperties({
        pagination: currentPagination
      });
    }
  }, [setProperties, pagination, sorting]);
  const items = (0, _react.useMemo)(() => buildItemsList(hostNodes), [hostNodes]);
  const clickedItem = (0, _react.useMemo)(() => items.find(({
    id
  }) => id === detailsItemId), [detailsItemId, items]);
  const currentPage = (0, _react.useMemo)(() => {
    const {
      pageSize = 0,
      pageIndex = 0
    } = pagination;
    const endIndex = (pageIndex + 1) * pageSize;
    const startIndex = pageIndex * pageSize;
    return items.sort(sortTableData(sorting)).slice(startIndex, endIndex);
  }, [items, pagination, sorting]);
  const metricColumnsWidth = displayAlerts ? '12%' : '16%';
  const columns = (0, _react.useMemo)(() => [{
    name: '',
    width: '40px',
    field: 'id',
    actions: [{
      name: _translations.TABLE_COLUMN_LABEL.toggleDialogAction,
      description: _translations.TABLE_COLUMN_LABEL.toggleDialogAction,
      icon: ({
        id
      }) => id === detailsItemId ? 'minimize' : 'expand',
      type: 'icon',
      'data-test-subj': 'hostsView-flyout-button',
      onClick: ({
        id
      }) => {
        setProperties({
          detailsItemId: id === detailsItemId ? null : id
        });
      }
    }]
  }, ...(displayAlerts ? [{
    name: /*#__PURE__*/_react.default.createElement(_column_header.ColumnHeader, {
      label: _translations.TABLE_COLUMN_LABEL.alertsCount,
      toolTip: _visualizations.METRICS_TOOLTIP.alertsCount,
      showDocumentationLink: false
    }),
    width: '95px',
    field: 'alertsCount',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-alertsCount',
    render: (alertsCount, row) => {
      if (!alertsCount) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: _translations.TABLE_CONTENT_LABEL.activeAlerts
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        iconType: "warning",
        color: "danger",
        onClick: () => {
          setProperties({
            detailsItemId: row.id === detailsItemId ? null : row.id
          });
        },
        onClickAriaLabel: _translations.TABLE_CONTENT_LABEL.activeAlerts,
        iconOnClick: () => {
          setProperties({
            detailsItemId: row.id === detailsItemId ? null : row.id
          });
        },
        iconOnClickAriaLabel: _translations.TABLE_CONTENT_LABEL.activeAlerts
      }, alertsCount));
    }
  }] : []), {
    name: _translations.TABLE_COLUMN_LABEL.title,
    field: 'title',
    sortable: true,
    truncateText: true,
    'data-test-subj': 'hostsView-tableRow-title',
    render: title => /*#__PURE__*/_react.default.createElement(_entry_title.EntryTitle, {
      title: title,
      onClick: () => reportHostEntryClick(title)
    }),
    width: displayAlerts ? '15%' : '20%'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_column_header.ColumnHeader, {
      label: _translations.TABLE_COLUMN_LABEL.cpuUsage,
      toolTip: _visualizations.METRICS_TOOLTIP.cpuUsage,
      formula: formulas === null || formulas === void 0 ? void 0 : formulas.cpuUsage.value
    }),
    width: metricColumnsWidth,
    field: 'cpu',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-cpuUsage',
    render: avg => formatMetric('cpu', avg),
    align: 'right'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_column_header.ColumnHeader, {
      label: _translations.TABLE_COLUMN_LABEL.normalizedLoad1m,
      toolTip: _visualizations.METRICS_TOOLTIP.normalizedLoad1m,
      formula: formulas === null || formulas === void 0 ? void 0 : formulas.normalizedLoad1m.value
    }),
    width: metricColumnsWidth,
    field: 'normalizedLoad1m',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-normalizedLoad1m',
    render: avg => formatMetric('normalizedLoad1m', avg),
    align: 'right'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_column_header.ColumnHeader, {
      label: _translations.TABLE_COLUMN_LABEL.memoryUsage,
      toolTip: _visualizations.METRICS_TOOLTIP.memoryUsage,
      formula: formulas === null || formulas === void 0 ? void 0 : formulas.memoryUsage.value
    }),
    width: metricColumnsWidth,
    field: 'memory',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-memoryUsage',
    render: avg => formatMetric('memory', avg),
    align: 'right'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_column_header.ColumnHeader, {
      label: _translations.TABLE_COLUMN_LABEL.memoryFree,
      toolTip: _visualizations.METRICS_TOOLTIP.memoryFree,
      formula: formulas === null || formulas === void 0 ? void 0 : formulas.memoryFree.value
    }),
    width: metricColumnsWidth,
    field: 'memoryFree',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-memoryFree',
    render: avg => formatMetric('memoryFree', avg),
    align: 'right'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_column_header.ColumnHeader, {
      label: _translations.TABLE_COLUMN_LABEL.diskSpaceUsage,
      toolTip: _visualizations.METRICS_TOOLTIP.diskUsage,
      formula: formulas === null || formulas === void 0 ? void 0 : formulas.diskUsage.value
    }),
    width: metricColumnsWidth,
    field: 'diskSpaceUsage',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-diskSpaceUsage',
    render: max => formatMetric('diskSpaceUsage', max),
    align: 'right'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_column_header.ColumnHeader, {
      label: _translations.TABLE_COLUMN_LABEL.rx,
      toolTip: _visualizations.METRICS_TOOLTIP.rx,
      formula: formulas === null || formulas === void 0 ? void 0 : formulas.rx.value
    }),
    width: '12%',
    field: 'rx',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-rx',
    render: avg => formatMetric('rx', avg),
    align: 'right'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_column_header.ColumnHeader, {
      label: _translations.TABLE_COLUMN_LABEL.tx,
      toolTip: _visualizations.METRICS_TOOLTIP.tx,
      formula: formulas === null || formulas === void 0 ? void 0 : formulas.tx.value
    }),
    width: '12%',
    field: 'tx',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-tx',
    render: avg => formatMetric('tx', avg),
    align: 'right'
  }], [detailsItemId, formulas === null || formulas === void 0 ? void 0 : formulas.cpuUsage.value, formulas === null || formulas === void 0 ? void 0 : formulas.diskUsage.value, formulas === null || formulas === void 0 ? void 0 : formulas.memoryFree.value, formulas === null || formulas === void 0 ? void 0 : formulas.memoryUsage.value, formulas === null || formulas === void 0 ? void 0 : formulas.normalizedLoad1m.value, formulas === null || formulas === void 0 ? void 0 : formulas.rx.value, formulas === null || formulas === void 0 ? void 0 : formulas.tx.value, reportHostEntryClick, setProperties, displayAlerts, metricColumnsWidth]);
  const selection = {
    onSelectionChange,
    selectable: item => !!item.name,
    selected: selectedItems
  };
  return {
    columns,
    clickedItem,
    currentPage,
    closeFlyout,
    items,
    isFlyoutOpen: detailsItemId !== null,
    onTableChange,
    pagination,
    sorting,
    selection,
    selectedItemsCount: selectedItems.length,
    filterSelectedHosts
  };
};
exports.useHostsTable = useHostsTable;
const HostsTable = exports.HostsTable = (0, _constate.default)(useHostsTable);
const [HostsTableProvider, useHostsTableContext] = HostsTable;
exports.useHostsTableContext = useHostsTableContext;
exports.HostsTableProvider = HostsTableProvider;