"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useControlPanels = exports.availableControlsPanels = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _react = require("react");
var _use_url_state = require("../../../../utils/use_url_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST_FILTERS_URL_STATE_KEY = 'controlPanels';
const availableControlsPanels = exports.availableControlsPanels = {
  HOST_OS_NAME: 'host.os.name',
  CLOUD_PROVIDER: 'cloud.provider',
  SERVICE_NAME: 'service.name'
};
const controlPanelConfigs = {
  [availableControlsPanels.HOST_OS_NAME]: {
    order: 0,
    width: 'medium',
    grow: false,
    type: 'optionsListControl',
    explicitInput: {
      id: availableControlsPanels.HOST_OS_NAME,
      fieldName: availableControlsPanels.HOST_OS_NAME,
      title: 'Operating System'
    }
  },
  [availableControlsPanels.CLOUD_PROVIDER]: {
    order: 1,
    width: 'medium',
    grow: false,
    type: 'optionsListControl',
    explicitInput: {
      id: availableControlsPanels.CLOUD_PROVIDER,
      fieldName: availableControlsPanels.CLOUD_PROVIDER,
      title: 'Cloud Provider'
    }
  },
  [availableControlsPanels.SERVICE_NAME]: {
    order: 2,
    width: 'medium',
    grow: false,
    type: 'optionsListControl',
    explicitInput: {
      id: availableControlsPanels.SERVICE_NAME,
      fieldName: availableControlsPanels.SERVICE_NAME,
      title: 'Service Name'
    }
  }
};
const availableControlPanelFields = Object.values(availableControlsPanels);
const useControlPanels = dataView => {
  const defaultState = (0, _react.useMemo)(() => getVisibleControlPanelsConfig(dataView), [dataView]);
  const [controlPanels, setControlPanels] = (0, _use_url_state.useUrlState)({
    defaultState,
    decodeUrlState,
    encodeUrlState,
    urlStateKey: HOST_FILTERS_URL_STATE_KEY
  });

  /**
   * Configure the control panels as
   * 1. Available fields from the data view
   * 2. Existing filters from the URL parameter (not colliding with allowed fields from data view)
   * 3. Enhanced with dataView.id
   */
  const controlsPanelsWithId = dataView ? mergeDefaultPanelsWithUrlConfig(dataView, controlPanels) : {};
  return [controlsPanelsWithId, setControlPanels];
};

/**
 * Utils
 */
exports.useControlPanels = useControlPanels;
const getVisibleControlPanels = dataView => {
  return availableControlPanelFields.filter(panelKey => (dataView === null || dataView === void 0 ? void 0 : dataView.fields.getByName(panelKey)) !== undefined);
};
const getVisibleControlPanelsConfig = dataView => {
  return getVisibleControlPanels(dataView).reduce((panelsMap, panelKey) => {
    const config = controlPanelConfigs[panelKey];
    return {
      ...panelsMap,
      [panelKey]: config
    };
  }, {});
};
const addDataViewIdToControlPanels = (controlPanels, dataViewId = '') => {
  return Object.entries(controlPanels).reduce((acc, [key, controlPanelConfig]) => {
    return {
      ...acc,
      [key]: {
        ...controlPanelConfig,
        explicitInput: {
          ...controlPanelConfig.explicitInput,
          dataViewId
        }
      }
    };
  }, {});
};
const cleanControlPanels = controlPanels => {
  return Object.entries(controlPanels).reduce((acc, [key, controlPanelConfig]) => {
    const {
      explicitInput
    } = controlPanelConfig;
    const {
      dataViewId,
      ...rest
    } = explicitInput;
    return {
      ...acc,
      [key]: {
        ...controlPanelConfig,
        explicitInput: rest
      }
    };
  }, {});
};
const mergeDefaultPanelsWithUrlConfig = (dataView, urlPanels = {}) => {
  // Get default panel configs from existing fields in data view
  const visiblePanels = getVisibleControlPanelsConfig(dataView);

  // Get list of panel which can be overridden to avoid merging additional config from url
  const existingKeys = Object.keys(visiblePanels);
  const controlPanelsToOverride = (0, _lodash.pick)(urlPanels, existingKeys);

  // Merge default and existing configs and add dataView.id to each of them
  return addDataViewIdToControlPanels({
    ...visiblePanels,
    ...controlPanelsToOverride
  }, dataView.id);
};
const PanelRT = rt.type({
  order: rt.number,
  width: rt.union([rt.literal('medium'), rt.literal('small'), rt.literal('large')]),
  grow: rt.boolean,
  type: rt.string,
  explicitInput: rt.intersection([rt.type({
    id: rt.string
  }), rt.partial({
    dataViewId: rt.string,
    fieldName: rt.string,
    title: rt.union([rt.string, rt.undefined]),
    selectedOptions: rt.array(rt.string)
  })])
});
const ControlPanelRT = rt.record(rt.string, PanelRT);
const encodeUrlState = value => {
  if (value) {
    // Remove the dataView.id on update to make the control panels portable between data views
    const cleanPanels = cleanControlPanels(value);
    return ControlPanelRT.encode(cleanPanels);
  }
};
const decodeUrlState = value => {
  if (value) {
    return (0, _pipeable.pipe)(ControlPanelRT.decode(value), (0, _Either.fold)((0, _function.constant)({}), _function.identity));
  }
};