"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntryTitle = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _customIcons = require("@kbn/custom-icons");
var _use_node_details_redirect = require("../../../../link_to/use_node_details_redirect");
var _use_unified_search = require("../../hooks/use_unified_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntryTitle = ({
  onClick,
  title
}) => {
  const {
    name,
    cloudProvider
  } = title;
  const {
    parsedDateRange
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    getNodeDetailUrl
  } = (0, _use_node_details_redirect.useNodeDetailsRedirect)();
  const link = getNodeDetailUrl({
    assetId: name,
    assetType: 'host',
    search: {
      from: parsedDateRange !== null && parsedDateRange !== void 0 && parsedDateRange.from ? new Date(parsedDateRange === null || parsedDateRange === void 0 ? void 0 : parsedDateRange.from).getTime() : undefined,
      to: parsedDateRange !== null && parsedDateRange !== void 0 && parsedDateRange.to ? new Date(parsedDateRange.to).getTime() : undefined,
      name
    }
  });
  const providerName = cloudProvider !== null && cloudProvider !== void 0 ? cloudProvider : 'Unknown';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    className: "eui-textTruncate",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: providerName
  }, /*#__PURE__*/_react.default.createElement(_customIcons.CloudProviderIcon, {
    cloudProvider: cloudProvider,
    size: "m",
    title: name
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate",
    onClick: onClick
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: name
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "hostsViewTableEntryTitleLink",
    className: "eui-displayBlock eui-textTruncate"
  }, link), name))));
};
exports.EntryTitle = EntryTitle;