"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlsContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/controls-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _rxjs = require("rxjs");
var _common = require("@kbn/kibana-react-plugin/common");
var _use_control_panels_url_state = require("../../hooks/use_control_panels_url_state");
var _controls_title = require("./controls_title");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ControlsContent = ({
  dataView,
  filters,
  query,
  timeRange,
  onFiltersChange
}) => {
  const [controlPanels, setControlPanels] = (0, _use_control_panels_url_state.useControlPanels)(dataView);
  const subscriptions = (0, _react.useRef)(new _rxjs.Subscription());
  const getInitialInput = (0, _react.useCallback)(loadedDataView => async () => {
    const initialInput = {
      id: loadedDataView.id,
      viewMode: _public2.ViewMode.VIEW,
      chainingSystem: 'HIERARCHICAL',
      controlStyle: 'oneLine',
      defaultControlWidth: 'small',
      panels: controlPanels,
      filters,
      query,
      timeRange
    };
    return {
      initialInput
    };
  }, [controlPanels, filters, query, timeRange]);
  const loadCompleteHandler = (0, _react.useCallback)(controlGroup => {
    if (!controlGroup) return;
    controlGroup.untilAllChildrenReady().then(() => {
      controlGroup.getChildIds().map(id => {
        const embeddable = controlGroup.getChild(id);
        embeddable.renderPrepend = () => /*#__PURE__*/_react.default.createElement(_controls_title.ControlTitle, {
          title: embeddable.getTitle(),
          embeddableId: id
        });
      });
    });
    subscriptions.current.add(controlGroup.onFiltersPublished$.subscribe(newFilters => {
      onFiltersChange(newFilters);
    }));
    subscriptions.current.add(controlGroup.getInput$().subscribe(({
      panels
    }) => setControlPanels(panels)));
  }, [onFiltersChange, setControlPanels]);
  (0, _react.useEffect)(() => {
    const currentSubscriptions = subscriptions.current;
    return () => {
      currentSubscriptions.unsubscribe();
    };
  }, []);
  if (!dataView) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ControlGroupContainer, null, /*#__PURE__*/_react.default.createElement(_public.ControlGroupRenderer, {
    getCreationOptions: getInitialInput(dataView),
    ref: loadCompleteHandler,
    timeRange: timeRange,
    query: query,
    filters: filters
  }));
};
exports.ControlsContent = ControlsContent;
const ControlGroupContainer = _common.euiStyled.div`
  .controlGroup {
    min-height: ${props => props.theme.eui.euiSizeXXL}
  }
`;