"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogColumnsConfigurationPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _source_configuration = require("../../../utils/source_configuration");
var _add_log_column_popover = require("./add_log_column_popover");
var _source_configuration_form_errors = require("./source_configuration_form_errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogColumnsConfigurationPanel = exports.LogColumnsConfigurationPanel = /*#__PURE__*/_react.default.memo(({
  availableFields,
  isLoading,
  logColumnsFormElement
}) => {
  const addLogColumn = (0, _react.useCallback)(logColumnConfiguration => logColumnsFormElement.updateValue(logColumns => [...logColumns, logColumnConfiguration]), [logColumnsFormElement]);
  const removeLogColumn = (0, _react.useCallback)(logColumn => logColumnsFormElement.updateValue(logColumns => logColumns.filter(item => item !== logColumn)), [logColumnsFormElement]);
  const moveLogColumn = (0, _react.useCallback)((sourceIndex, destinationIndex) => {
    logColumnsFormElement.updateValue(logColumns => {
      if (destinationIndex >= 0 && sourceIndex <= logColumnsFormElement.value.length - 1) {
        const newLogColumns = [...logColumnsFormElement.value];
        newLogColumns.splice(destinationIndex, 0, newLogColumns.splice(sourceIndex, 1)[0]);
        return newLogColumns;
      } else {
        return logColumns;
      }
    });
  }, [logColumnsFormElement]);
  const onDragEnd = (0, _react.useCallback)(({
    source,
    destination
  }) => destination && moveLogColumn(source.index, destination.index), [moveLogColumn]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "sourceConfigurationLogColumnsSectionTitle"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.logColumnsSectionTitle",
    defaultMessage: "Log columns"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_log_column_popover.AddLogColumnButtonAndPopover, {
    addLogColumn: addLogColumn,
    availableFields: availableFields,
    isDisabled: isLoading
  }))), logColumnsFormElement.value.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: onDragEnd
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: "COLUMN_CONFIG_DROPPABLE_AREA"
  }, logColumnsFormElement.value.map((logColumnConfiguration, index) => {
    const columnId = (0, _source_configuration.getLogColumnConfigurationId)(logColumnConfiguration);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
      key: `logColumnConfigurationPanel-${columnId}`,
      index: index,
      draggableId: columnId,
      customDragHandle: true
    }, provided => /*#__PURE__*/_react.default.createElement(LogColumnConfigurationPanel, {
      dragHandleProps: provided.dragHandleProps,
      logColumnConfiguration: logColumnConfiguration,
      onRemove: removeLogColumn
    }));
  }))) : /*#__PURE__*/_react.default.createElement(LogColumnConfigurationEmptyPrompt, null), logColumnsFormElement.validity.validity === 'invalid' ? logColumnsFormElement.validity.reasons.map(error => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    key: error.type,
    textAlign: "center",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_source_configuration_form_errors.LogSourceConfigurationFormError, {
    error: error
  }))) : null);
});
const LogColumnConfigurationPanel = ({
  logColumnConfiguration,
  dragHandleProps,
  onRemove
}) => {
  const removeColumn = (0, _react.useCallback)(() => onRemove(logColumnConfiguration), [logColumnConfiguration, onRemove]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), (0, _source_configuration.isTimestampLogColumnConfiguration)(logColumnConfiguration) ? /*#__PURE__*/_react.default.createElement(TimestampLogColumnConfigurationPanel, {
    dragHandleProps: dragHandleProps,
    logColumnConfiguration: logColumnConfiguration,
    onRemove: removeColumn
  }) : (0, _source_configuration.isMessageLogColumnConfiguration)(logColumnConfiguration) ? /*#__PURE__*/_react.default.createElement(MessageLogColumnConfigurationPanel, {
    dragHandleProps: dragHandleProps,
    logColumnConfiguration: logColumnConfiguration,
    onRemove: removeColumn
  }) : /*#__PURE__*/_react.default.createElement(FieldLogColumnConfigurationPanel, {
    dragHandleProps: dragHandleProps,
    logColumnConfiguration: logColumnConfiguration,
    onRemove: removeColumn
  }));
};
const TimestampLogColumnConfigurationPanel = ({
  dragHandleProps,
  onRemove
}) => /*#__PURE__*/_react.default.createElement(ExplainedLogColumnConfigurationPanel, {
  fieldName: "Timestamp",
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    tagName: "span",
    id: "xpack.infra.sourceConfiguration.timestampLogColumnDescription",
    defaultMessage: "This system field shows the log entry's time as determined by the {timestampSetting} field setting.",
    values: {
      timestampSetting: /*#__PURE__*/_react.default.createElement("code", null, "timestamp")
    }
  }),
  onRemove: onRemove,
  dragHandleProps: dragHandleProps
});
const MessageLogColumnConfigurationPanel = ({
  dragHandleProps,
  onRemove
}) => /*#__PURE__*/_react.default.createElement(ExplainedLogColumnConfigurationPanel, {
  fieldName: "Message",
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    tagName: "span",
    id: "xpack.infra.sourceConfiguration.messageLogColumnDescription",
    defaultMessage: "This system field shows the log entry message as derived from the document fields."
  }),
  onRemove: onRemove,
  dragHandleProps: dragHandleProps
});
const FieldLogColumnConfigurationPanel = ({
  dragHandleProps,
  logColumnConfiguration: {
    fieldColumn: {
      field
    }
  },
  onRemove
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    "data-test-subj": `logColumnPanel fieldLogColumnPanel fieldLogColumnPanel:${field}`,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    "data-test-subj": "moveLogColumnHandle"
  }, dragHandleProps), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grab"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, fieldLogColumnTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement("code", null, field)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(RemoveLogColumnButton, {
    onClick: onRemove,
    columnDescription: `${fieldLogColumnTitle} - ${field}`
  }))));
};
const ExplainedLogColumnConfigurationPanel = ({
  fieldName,
  helpText,
  onRemove,
  dragHandleProps
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  color: "subdued",
  "data-test-subj": `logColumnPanel systemLogColumnPanel systemLogColumnPanel:${fieldName}`,
  hasShadow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
  "data-test-subj": "moveLogColumnHandle"
}, dragHandleProps), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "grab"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 1
}, fieldName), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 3
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  color: "subdued"
}, helpText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(RemoveLogColumnButton, {
  onClick: onRemove,
  columnDescription: String(fieldName)
}))));
const RemoveLogColumnButton = ({
  onClick,
  columnDescription
}) => {
  const removeColumnLabel = _i18n.i18n.translate('xpack.infra.sourceConfiguration.removeLogColumnButtonLabel', {
    defaultMessage: 'Remove {columnDescription} column',
    values: {
      columnDescription
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    "data-test-subj": "removeLogColumnButton",
    iconType: "trash",
    onClick: onClick,
    title: removeColumnLabel,
    "aria-label": removeColumnLabel
  });
};
const LogColumnConfigurationEmptyPrompt = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  iconType: "list",
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.noLogColumnsTitle",
    defaultMessage: "No columns"
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.noLogColumnsDescription",
    defaultMessage: "Add a column to this list using the button above."
  }))
});
const fieldLogColumnTitle = _i18n.i18n.translate('xpack.infra.sourceConfiguration.fieldLogColumnTitle', {
  defaultMessage: 'Field'
});