"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicesConfigurationPanel = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _common = require("@kbn/logs-shared-plugin/common");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public3 = require("@kbn/observability-plugin/public");
var _use_kibana = require("../../../hooks/use_kibana");
var _form_elements = require("./form_elements");
var _index_names_configuration_panel = require("./index_names_configuration_panel");
var _index_pattern_configuration_panel = require("./index_pattern_configuration_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndicesConfigurationPanel = exports.IndicesConfigurationPanel = /*#__PURE__*/_react.default.memo(({
  isLoading,
  isReadOnly,
  indicesFormElement
}) => {
  const {
    services: {
      http,
      share: {
        url: {
          locators
        }
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [numberOfLogsRules, setNumberOfLogsRules] = (0, _react.useState)(0);
  const rulesLocator = locators.get(_public3.rulesLocatorID);
  const viewAffectedRulesLink = rulesLocator === null || rulesLocator === void 0 ? void 0 : rulesLocator.useUrl({
    type: [_ruleDataUtils.LOG_THRESHOLD_ALERT_TYPE_ID]
  });
  const trackChangeIndexSourceType = (0, _public.useUiTracker)({
    app: 'infra_logs'
  });
  const changeToIndexPatternType = (0, _react.useCallback)(() => {
    if (_common.logDataViewReferenceRT.is(indicesFormElement.initialValue)) {
      indicesFormElement.updateValue(() => indicesFormElement.initialValue);
    } else {
      indicesFormElement.updateValue(() => undefined);
    }
    trackChangeIndexSourceType({
      metric: 'configuration_switch_to_index_pattern_reference'
    });
  }, [indicesFormElement, trackChangeIndexSourceType]);
  const changeToIndexNameType = (0, _react.useCallback)(() => {
    var _indicesFormElement$i;
    if (((_indicesFormElement$i = indicesFormElement.initialValue) === null || _indicesFormElement$i === void 0 ? void 0 : _indicesFormElement$i.type) === 'index_name') {
      indicesFormElement.updateValue(() => indicesFormElement.initialValue);
    } else {
      indicesFormElement.updateValue(() => ({
        type: 'index_name',
        indexName: ''
      }));
    }
    trackChangeIndexSourceType({
      metric: 'configuration_switch_to_index_names_reference'
    });
  }, [indicesFormElement, trackChangeIndexSourceType]);
  (0, _react.useEffect)(() => {
    const getNumberOfInfraRules = async () => {
      if (http) {
        const {
          ruleExecutionStatus
        } = await (0, _public2.loadRuleAggregations)({
          http,
          typesFilter: [_ruleDataUtils.LOG_THRESHOLD_ALERT_TYPE_ID]
        });
        const numberOfRules = Object.values(ruleExecutionStatus).reduce((acc, value) => acc + value, 0);
        setNumberOfLogsRules(numberOfRules);
      }
    };
    getNumberOfInfraRules();
  }, [http]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    legend: {
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logSourceConfiguration.logSourcesTitle",
        defaultMessage: "Log sources"
      })))
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: "dataView",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceConfiguration.dataViewSectionTitle",
      defaultMessage: "Data view (recommended)"
    }))),
    name: "dataView",
    value: "dataView",
    checked: isDataViewFormElement(indicesFormElement),
    onChange: changeToIndexPatternType,
    disabled: isReadOnly
  }, isDataViewFormElement(indicesFormElement) && /*#__PURE__*/_react.default.createElement(_index_pattern_configuration_panel.IndexPatternConfigurationPanel, {
    isLoading: isLoading,
    isReadOnly: isReadOnly,
    indexPatternFormElement: indicesFormElement
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: "indexNames",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.sourceConfiguration.indicesSectionTitle",
      defaultMessage: "Indices"
    }))),
    name: "indexNames",
    value: "indexNames",
    checked: isIndexNamesFormElement(indicesFormElement),
    onChange: changeToIndexNameType,
    disabled: isReadOnly
  }, isIndexNamesFormElement(indicesFormElement) && /*#__PURE__*/_react.default.createElement(_index_names_configuration_panel.IndexNamesConfigurationPanel, {
    isLoading: isLoading,
    isReadOnly: isReadOnly,
    indexNamesFormElement: indicesFormElement
  })), numberOfLogsRules > 0 && indicesFormElement.isDirty && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "infraIndicesPanelSettingsWarningCallout",
    size: "m",
    title: _i18n.i18n.translate('xpack.infra.sourceConfiguration.logsIndicesUsedByRulesTitle', {
      defaultMessage: 'Alerting rules use this data source setting'
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.logsIndicesUsedByRulesMessage",
    defaultMessage: "One or more alerting rules rely on this data source setting. Changing this setting will change which data is used to generate alerts."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "logIndicesViewAffectedRulesLink",
    href: viewAffectedRulesLink,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.logIndices.viewAffectedRulesLink",
    defaultMessage: "View affected rules"
  })))));
});
const isDataViewFormElement = (0, _form_elements.isFormElementForType)(value => value == null || _common.logDataViewReferenceRT.is(value));
const isIndexNamesFormElement = (0, _form_elements.isFormElementForType)(_common.logIndexNameReferenceRT.is);