"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsPageProviders = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/logs-shared-plugin/public");
var _log_analysis = require("../../containers/logs/log_analysis");
var _use_kibana = require("../../hooks/use_kibana");
var _kbn_url_state_context = require("../../utils/kbn_url_state_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogsPageProviders = ({
  children
}) => {
  const {
    services: {
      notifications: {
        toasts: toastsService
      },
      logsShared
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const urlStateStorage = (0, _kbn_url_state_context.useKbnUrlStateStorageFromRouterContext)();
  const [initializeFromUrl] = (0, _react.useState)(() => {
    return (0, _public.initializeFromUrl)({
      toastsService,
      urlStateStorage
    });
  });
  const [updateContextInUrl] = (0, _react.useState)(() => {
    return (0, _public.updateContextInUrl)({
      toastsService,
      urlStateStorage
    });
  });
  const [listenForUrlChanges] = (0, _react.useState)(() => {
    return (0, _public.listenForUrlChanges)({
      urlStateStorage
    });
  });
  return /*#__PURE__*/_react.default.createElement(_public.LogViewProvider, {
    logViews: logsShared.logViews.client,
    initializeFromUrl: initializeFromUrl,
    updateContextInUrl: updateContextInUrl,
    listenForUrlChanges: listenForUrlChanges
  }, /*#__PURE__*/_react.default.createElement(_log_analysis.LogAnalysisCapabilitiesProvider, null, children));
};
exports.LogsPageProviders = LogsPageProviders;