"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogAnalysisResultsUrlState = exports.stringTimeRangeRT = void 0;
var _react = require("react");
var _useInterval = _interopRequireDefault(require("react-use/lib/useInterval"));
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _moment = _interopRequireDefault(require("moment"));
var rt = _interopRequireWildcard(require("io-ts"));
var _use_url_state = require("../../../utils/use_url_state");
var _use_kibana_timefilter_time = require("../../../hooks/use_kibana_timefilter_time");
var _runtime_types = require("../../../../common/runtime_types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const autoRefreshRT = rt.type({
  interval: rt.number,
  isPaused: rt.boolean
});
const urlAutoRefreshRT = rt.union([autoRefreshRT, rt.undefined]);
const decodeAutoRefreshUrlState = (0, _runtime_types.decodeOrThrow)(urlAutoRefreshRT);
const defaultAutoRefreshState = {
  isPaused: false,
  interval: 30000
};
const stringTimeRangeRT = exports.stringTimeRangeRT = rt.type({
  startTime: rt.string,
  endTime: rt.string
});
const urlTimeRangeRT = rt.union([stringTimeRangeRT, rt.undefined]);
const decodeTimeRangeUrlState = (0, _runtime_types.decodeOrThrow)(urlTimeRangeRT);
const TIME_RANGE_URL_STATE_KEY = 'timeRange';
const AUTOREFRESH_URL_STATE_KEY = 'autoRefresh';
const TIME_DEFAULTS = {
  from: 'now-2w',
  to: 'now'
};
const useLogAnalysisResultsUrlState = () => {
  const [getTime] = (0, _use_kibana_timefilter_time.useKibanaTimefilterTime)(TIME_DEFAULTS);
  const {
    from: start,
    to: end
  } = getTime();
  const defaultTimeRangeState = (0, _react.useMemo)(() => {
    return {
      startTime: start,
      endTime: end
    };
  }, [start, end]);
  const [urlTimeRange, setUrlTimeRange] = (0, _use_url_state.useUrlState)({
    defaultState: defaultTimeRangeState,
    decodeUrlState: decodeTimeRangeUrlState,
    encodeUrlState: urlTimeRangeRT.encode,
    urlStateKey: TIME_RANGE_URL_STATE_KEY,
    writeDefaultState: true
  });

  // Numeric time range for querying APIs
  const [queryTimeRange, setQueryTimeRange] = (0, _react.useState)(() => ({
    value: stringToNumericTimeRange({
      start: urlTimeRange.startTime,
      end: urlTimeRange.endTime
    }),
    lastChangedTime: Date.now()
  }));
  const handleQueryTimeRangeChange = (0, _react.useCallback)(({
    start: startTime,
    end: endTime
  }) => {
    setQueryTimeRange({
      value: stringToNumericTimeRange({
        start: startTime,
        end: endTime
      }),
      lastChangedTime: Date.now()
    });
  }, [setQueryTimeRange]);
  const setTimeRange = (0, _react.useCallback)(selectedTime => {
    setUrlTimeRange({
      startTime: selectedTime.start,
      endTime: selectedTime.end
    });
    handleQueryTimeRangeChange(selectedTime);
  }, [setUrlTimeRange, handleQueryTimeRangeChange]);
  const handleTimeFilterChange = (0, _react.useCallback)(newTimeRange => {
    const {
      from,
      to
    } = newTimeRange;
    setTimeRange({
      start: from,
      end: to
    });
  }, [setTimeRange]);
  (0, _use_kibana_timefilter_time.useSyncKibanaTimeFilterTime)(TIME_DEFAULTS, {
    from: urlTimeRange.startTime,
    to: urlTimeRange.endTime
  }, handleTimeFilterChange);
  const [autoRefresh, setAutoRefresh] = (0, _use_url_state.useUrlState)({
    defaultState: defaultAutoRefreshState,
    decodeUrlState: decodeAutoRefreshUrlState,
    encodeUrlState: urlAutoRefreshRT.encode,
    urlStateKey: AUTOREFRESH_URL_STATE_KEY,
    writeDefaultState: true
  });
  (0, _useInterval.default)(() => {
    handleQueryTimeRangeChange({
      start: urlTimeRange.startTime,
      end: urlTimeRange.endTime
    });
  }, autoRefresh.isPaused ? null : autoRefresh.interval);
  return {
    timeRange: queryTimeRange,
    friendlyTimeRange: urlTimeRange,
    setTimeRange,
    autoRefresh,
    setAutoRefresh
  };
};
exports.useLogAnalysisResultsUrlState = useLogAnalysisResultsUrlState;
const stringToNumericTimeRange = timeRange => ({
  startTime: (0, _moment.default)(_datemath.default.parse(timeRange.start, {
    momentInstance: _moment.default
  })).valueOf(),
  endTime: (0, _moment.default)(_datemath.default.parse(timeRange.end, {
    momentInstance: _moment.default,
    roundUp: true
  })).valueOf()
});