"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNodeDetailsRedirect = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _routerUtils = require("@kbn/router-utils");
var _public = require("@kbn/observability-shared-plugin/public");
var _use_kibana = require("../../hooks/use_kibana");
var _redirect_to_node_detail = require("./redirect_to_node_detail");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNodeDetailsRedirect = () => {
  const location = (0, _reactRouterDom.useLocation)();
  const {
    services: {
      application: {
        currentAppId$
      },
      share
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const appId = (0, _useObservable.default)(currentAppId$);
  const locator = share.url.locators.get(_public.ASSET_DETAILS_LOCATOR_ID);
  const getNodeDetailUrl = (0, _react.useCallback)(({
    assetType,
    assetId,
    search
  }) => {
    var _location$state;
    const {
      from,
      to,
      ...additionalParams
    } = search;
    const queryParams = {
      assetDetails: Object.keys(additionalParams).length > 0 ? {
        ...additionalParams,
        dateRange: {
          from: from ? new Date(from).toISOString() : undefined,
          to: to ? new Date(to).toISOString() : undefined
        }
      } : {},
      _a: {
        time: {
          ...(from ? {
            [_redirect_to_node_detail.REDIRECT_NODE_DETAILS_FROM_KEY]: new Date(from).toISOString()
          } : undefined),
          interval: '>=1m',
          // need to pass the interval to consider the time valid
          ...(to ? {
            [_redirect_to_node_detail.REDIRECT_NODE_DETAILS_TO_KEY]: new Date(to).toISOString()
          } : undefined)
        }
      }
    };
    const nodeDetailsLocatorParams = {
      ...queryParams,
      assetType,
      assetId,
      state: {
        ...((_location$state = location.state) !== null && _location$state !== void 0 ? _location$state : {}),
        ...(location.key ? {
          originAppId: appId,
          originSearch: location.search,
          originPathname: location.pathname
        } : {})
      }
    };
    const nodeDetailsLinkProps = (0, _routerUtils.getRouterLinkProps)({
      href: locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl(nodeDetailsLocatorParams),
      onClick: () => {
        locator === null || locator === void 0 ? void 0 : locator.navigate(nodeDetailsLocatorParams, {
          replace: false
        });
      }
    });
    return nodeDetailsLinkProps;
  }, [appId, location.key, location.pathname, location.search, location.state, locator]);
  return {
    getNodeDetailUrl
  };
};
exports.useNodeDetailsRedirect = useNodeDetailsRedirect;