"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateContextInUrl = exports.safeDefaultParsedQuery = exports.legacyPositionStateInUrlRT = exports.legacyFilterStateInUrlRT = exports.initializeFromUrl = exports.filterStateInUrlRT = exports.filterMeta = exports.filter = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var Array = _interopRequireWildcard(require("fp-ts/lib/Array"));
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _function = require("fp-ts/lib/function");
var rt = _interopRequireWildcard(require("io-ts"));
var _common = require("@kbn/logs-shared-plugin/common");
var _moment = _interopRequireDefault(require("moment"));
var _url_state_storage_service = require("../../../../common/url_state_storage_service");
var _time = require("../../../../common/time");
var _datemath = require("../../../utils/datemath");
var _runtime_types = require("../../../../common/runtime_types");
var _defaults = require("./defaults");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const requiredDefaultFilterStateValue = {
  query: _defaults.DEFAULT_QUERY,
  filters: _defaults.DEFAULT_FILTERS
};
const optionalDefaultFilterStateValue = {
  timeRange: _defaults.DEFAULT_TIMERANGE,
  refreshInterval: _common.DEFAULT_REFRESH_INTERVAL
};
const defaultFilterStateValue = {
  ...requiredDefaultFilterStateValue,
  ...optionalDefaultFilterStateValue
};
const safeDefaultParsedQuery = exports.safeDefaultParsedQuery = {
  bool: {
    must: [],
    must_not: [],
    should: [],
    filter: [{
      match_none: {}
    }]
  }
};
const updateContextInUrl = ({
  urlStateStorage,
  filterStateKey = _common.defaultFilterStateKey
}) => (context, _event) => {
  if (!('query' in context) || !('filters' in context) || !('timeRange' in context) || !('refreshInterval' in context)) {
    throw new Error('Missing keys from context needed to sync to the URL');
  }
  urlStateStorage.set(filterStateKey, filterStateInUrlRT.encode({
    query: context.query,
    filters: context.filters,
    timeRange: context.timeRange,
    refreshInterval: context.refreshInterval
  }), {
    replace: true
  });
};
exports.updateContextInUrl = updateContextInUrl;
const initializeFromUrl = ({
  filterStateKey = _common.defaultFilterStateKey,
  positionStateKey = _common.defaultPositionStateKey,
  toastsService,
  urlStateStorage
}) => (_context, _event) => send => {
  var _urlStateStorage$get, _urlStateStorage$get2;
  const filterQueryValueFromUrl = (_urlStateStorage$get = urlStateStorage.get(filterStateKey)) !== null && _urlStateStorage$get !== void 0 ? _urlStateStorage$get : requiredDefaultFilterStateValue;
  const filterQueryE = decodeFilterQueryValueFromUrl(filterQueryValueFromUrl);

  // NOTE: Access logPosition for backwards compatibility with values previously stored under that key.
  const positionQueryValueFromUrl = (_urlStateStorage$get2 = urlStateStorage.get(positionStateKey)) !== null && _urlStateStorage$get2 !== void 0 ? _urlStateStorage$get2 : {};
  const positionQueryE = decodePositionQueryValueFromUrl(positionQueryValueFromUrl);
  if (Either.isLeft(filterQueryE) || Either.isLeft(positionQueryE)) {
    (0, _public.withNotifyOnErrors)(toastsService).onGetError((0, _runtime_types.createPlainError)((0, _runtime_types.formatErrors)([...(Either.isLeft(filterQueryE) ? filterQueryE.left : []), ...(Either.isLeft(positionQueryE) ? positionQueryE.left : [])])));
    send({
      type: 'INITIALIZED_FROM_URL',
      query: defaultFilterStateValue.query,
      filters: defaultFilterStateValue.filters,
      timeRange: null,
      refreshInterval: null
    });
  } else {
    var _filterQueryE$right$q, _filterQueryE$right$f;
    send({
      type: 'INITIALIZED_FROM_URL',
      query: (_filterQueryE$right$q = filterQueryE.right.query) !== null && _filterQueryE$right$q !== void 0 ? _filterQueryE$right$q : defaultFilterStateValue.query,
      filters: (_filterQueryE$right$f = filterQueryE.right.filters) !== null && _filterQueryE$right$f !== void 0 ? _filterQueryE$right$f : defaultFilterStateValue.filters,
      timeRange: (0, _function.pipe)(
      // Via the logFilter key
      (0, _function.pipe)(filterQueryE.right.timeRange, Either.fromNullable(null), Either.chain(({
        from,
        to
      }) => from && to ? Either.right({
        from,
        to
      }) : Either.left(null))),
      // Via the legacy logPosition key, and start / end timeRange parameters
      Either.alt(() => (0, _function.pipe)(positionQueryE.right, Either.fromNullable(null), Either.chain(({
        start,
        end
      }) => start && end ? Either.right({
        from: start,
        to: end
      }) : Either.left(null)))),
      // Via the legacy logPosition key, and deriving from / to from position.time
      Either.alt(() => (0, _function.pipe)(positionQueryE.right, Either.fromNullable(null), Either.chain(({
        position
      }) => position && position.time ? Either.right({
        from: (0, _url_state_storage_service.getTimeRangeStartFromTime)((0, _moment.default)(position.time).valueOf()),
        to: (0, _url_state_storage_service.getTimeRangeEndFromTime)((0, _moment.default)(position.time).valueOf())
      }) : Either.left(null)))), Either.fold(_function.identity, _function.identity)),
      refreshInterval: (0, _function.pipe)(
      // Via the logFilter key
      (0, _function.pipe)(filterQueryE.right.refreshInterval, Either.fromNullable(null)),
      // Via the legacy logPosition key, and the boolean streamLive parameter
      Either.alt(() => (0, _function.pipe)(positionQueryE.right, Either.fromNullable(null), Either.chain(({
        streamLive
      }) => typeof streamLive === 'boolean' ? Either.right({
        pause: !streamLive,
        value: defaultFilterStateValue.refreshInterval.value // NOTE: Was not previously synced to the URL, so falls straight to the default.
      }) : Either.left(null)))), Either.fold(_function.identity, _function.identity))
    });
  }
};
exports.initializeFromUrl = initializeFromUrl;
const legacyLegacyFilterStateWithExpressionInUrlRT = rt.type({
  kind: rt.literal('kuery'),
  expression: rt.string
});
const legacyPositionStateInUrlRT = exports.legacyPositionStateInUrlRT = rt.partial({
  streamLive: rt.boolean,
  start: _datemath.datemathStringRT,
  end: _datemath.datemathStringRT,
  position: rt.union([rt.partial(_time.minimalTimeKeyRT.props), rt.null])
});
const decodeFilterQueryValueFromUrl = queryValueFromUrl => Either.getAltValidation(Array.getMonoid()).alt((0, _function.pipe)((0, _function.pipe)(legacyLegacyFilterStateWithExpressionInUrlRT.decode(queryValueFromUrl), Either.map(({
  expression,
  kind
}) => ({
  query: {
    language: kind,
    query: expression
  }
}))), Either.alt(() => (0, _function.pipe)(legacyFilterStateInUrlRT.decode(queryValueFromUrl), Either.map(legacyQuery => ({
  query: legacyQuery
}))))), () => filterStateInUrlRT.decode(queryValueFromUrl));
const decodePositionQueryValueFromUrl = queryValueFromUrl => {
  return legacyPositionStateInUrlRT.decode(queryValueFromUrl);
};
const filterMeta = exports.filterMeta = rt.partial({
  alias: rt.union([rt.string, rt.null]),
  disabled: rt.boolean,
  negate: rt.boolean,
  controlledBy: rt.string,
  group: rt.string,
  index: rt.string,
  isMultiIndex: rt.boolean,
  type: rt.string,
  key: rt.string,
  params: rt.any,
  value: rt.any
});
const filter = exports.filter = rt.intersection([rt.type({
  meta: filterMeta
}), rt.partial({
  query: rt.UnknownRecord
})]);
const filterStateInUrlRT = exports.filterStateInUrlRT = rt.partial({
  query: rt.union([rt.strict({
    language: rt.string,
    query: rt.union([rt.string, rt.record(rt.string, rt.unknown)])
  }), rt.strict({
    esql: rt.string
  })]),
  filters: rt.array(filter),
  timeRange: rt.strict({
    from: rt.string,
    to: rt.string
  }),
  refreshInterval: rt.strict({
    pause: rt.boolean,
    value: rt.number
  })
});
const legacyFilterStateInUrlRT = exports.legacyFilterStateInUrlRT = rt.union([rt.strict({
  language: rt.string,
  query: rt.union([rt.string, rt.record(rt.string, rt.unknown)])
}), rt.strict({
  esql: rt.string
})]);