"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMetricsBreadcrumbs = void 0;
var _react = require("react");
var _public = require("@kbn/observability-shared-plugin/public");
var _constants = require("../../common/constants");
var _translations = require("../translations");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMetricsBreadcrumbs = (extraCrumbs, options) => {
  const {
    services: {
      serverless
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const appLinkProps = (0, _public.useLinkProps)({
    app: _constants.METRICS_APP
  });
  const breadcrumbs = (0, _react.useMemo)(() => [{
    ...appLinkProps,
    text: _translations.metricsTitle
  }, ...extraCrumbs], [appLinkProps, extraCrumbs]);
  (0, _public.useBreadcrumbs)(breadcrumbs);
  (0, _react.useEffect)(() => {
    // For deeper context breadcrumbs in serveless, the `serverless` plugin provides its own breadcrumb service.
    // https://docs.elastic.dev/kibana-dev-docs/serverless-project-navigation#breadcrumbs
    if (serverless && options !== null && options !== void 0 && options.deeperContextServerless) {
      // The initial path is already set in the breadcrumbs
      const [, ...serverlessBreadcrumbs] = breadcrumbs;
      serverless.setBreadcrumbs(serverlessBreadcrumbs);
    }
  }, [breadcrumbs, options === null || options === void 0 ? void 0 : options.deeperContextServerless, serverless]);
};
exports.useMetricsBreadcrumbs = useMetricsBreadcrumbs;