"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHTTPRequest = useHTTPRequest;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/kibana-utils-plugin/common");
var _use_tracked_promise = require("../utils/use_tracked_promise");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useHTTPRequest(pathname, method, body, decode = response => response, fetch, toastDanger, abortable = false, fetchOptions) {
  var _kibana$services$http;
  const kibana = (0, _public.useKibana)();
  const fetchService = fetch ? fetch : (_kibana$services$http = kibana.services.http) === null || _kibana$services$http === void 0 ? void 0 : _kibana$services$http.fetch;
  const toast = toastDanger ? toastDanger : kibana.notifications.toasts.danger;
  const [response, setResponse] = (0, _react.useState)(null);
  const [error, setError] = (0, _react.useState)(null);
  const abortController = (0, _react.useRef)(new AbortController());
  const onError = (0, _react.useCallback)(e => {
    var _err$response, _err$response2, _err$response3, _err$body, _err$body2;
    const err = e;
    if (e && (e instanceof _use_tracked_promise.CanceledPromiseError || e.name === _common.AbortError.name)) {
      return;
    }
    setError(err);
    toast({
      toastLifeTimeMs: 3000,
      title: _i18n.i18n.translate('xpack.infra.useHTTPRequest.error.title', {
        defaultMessage: `Error while fetching resource`
      }),
      body: /*#__PURE__*/_react.default.createElement("div", null, err.response ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.infra.useHTTPRequest.error.status', {
        defaultMessage: `Error`
      })), (_err$response = err.response) === null || _err$response === void 0 ? void 0 : _err$response.statusText, " (", (_err$response2 = err.response) === null || _err$response2 === void 0 ? void 0 : _err$response2.status, ")", /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.infra.useHTTPRequest.error.url', {
        defaultMessage: `URL`
      })), (_err$response3 = err.response) === null || _err$response3 === void 0 ? void 0 : _err$response3.url, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.infra.useHTTPRequest.error.body.message', {
        defaultMessage: `Message`
      })), ((_err$body = err.body) === null || _err$body === void 0 ? void 0 : _err$body.message) || err.message) : /*#__PURE__*/_react.default.createElement("h5", null, ((_err$body2 = err.body) === null || _err$body2 === void 0 ? void 0 : _err$body2.message) || err.message))
    });
  }, [toast]);
  (0, _react.useEffect)(() => {
    return () => {
      if (abortable) {
        abortController.current.abort();
      }
    };
  }, [abortable]);
  const [request, makeRequest, resetRequestState] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'resolution',
    createPromise: () => {
      if (!fetchService) {
        throw new Error('HTTP service is unavailable');
      }
      if (abortable) {
        abortController.current.abort();
      }
      abortController.current = new AbortController();
      return fetchService(pathname, {
        signal: abortController.current.signal,
        method,
        body,
        ...fetchOptions
      });
    },
    onResolve: resp => {
      try {
        setResponse(decode(resp)); // Catch decoding errors
        setError(null);
      } catch (e) {
        onError(e);
      }
    },
    onReject: e => {
      onError(e);
    }
  }, [pathname, body, method, fetch, toast, onError, fetchOptions]);
  const loading = request.state === 'uninitialized' || request.state === 'pending';
  return {
    response,
    error,
    loading,
    makeRequest,
    resetRequestState
  };
}