"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jobSummaryRT = exports.fetchJobStatusResponsePayloadRT = exports.fetchJobStatusRequestPayloadRT = exports.callJobsSummaryAPI = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _infra_ml = require("../../../../common/infra_ml");
var _runtime_types = require("../../../../common/runtime_types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const callJobsSummaryAPI = async (requestArgs, fetch) => {
  const {
    spaceId,
    sourceId,
    jobTypes
  } = requestArgs;
  const response = await fetch('/internal/ml/jobs/jobs_summary', {
    method: 'POST',
    version: '1',
    body: JSON.stringify(fetchJobStatusRequestPayloadRT.encode({
      jobIds: jobTypes.map(jobType => (0, _infra_ml.getJobId)(spaceId, sourceId, jobType))
    }))
  });
  return (0, _runtime_types.decodeOrThrow)(fetchJobStatusResponsePayloadRT)(response);
};
exports.callJobsSummaryAPI = callJobsSummaryAPI;
const fetchJobStatusRequestPayloadRT = exports.fetchJobStatusRequestPayloadRT = rt.type({
  jobIds: rt.array(rt.string)
});
const datafeedStateRT = rt.keyof({
  started: null,
  starting: null,
  stopped: null,
  stopping: null,
  '': null
});

// this is the union of the ML API's job state and block reasons
const jobStateRT = rt.keyof({
  closed: null,
  closing: null,
  deleting: null,
  failed: null,
  opened: null,
  opening: null,
  resetting: null,
  reverting: null
});
const jobCategorizationStatusRT = rt.keyof({
  ok: null,
  warn: null
});
const jobModelSizeStatsRT = rt.type({
  categorization_status: jobCategorizationStatusRT,
  categorized_doc_count: rt.number,
  dead_category_count: rt.number,
  frequent_category_count: rt.number,
  rare_category_count: rt.number,
  total_category_count: rt.number
});
const jobSummaryRT = exports.jobSummaryRT = rt.intersection([rt.type({
  id: rt.string,
  jobState: jobStateRT
}), rt.partial({
  awaitingNodeAssignment: rt.boolean,
  datafeedIndices: rt.array(rt.string),
  datafeedState: datafeedStateRT,
  fullJob: rt.partial({
    custom_settings: _infra_ml.jobCustomSettingsRT,
    finished_time: rt.number,
    model_size_stats: jobModelSizeStatsRT
  })
})]);
const fetchJobStatusResponsePayloadRT = exports.fetchJobStatusResponsePayloadRT = rt.array(jobSummaryRT);