"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogEntryRateModuleContext = exports.useLogEntryRateModule = exports.LogEntryRateModuleProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _log_analysis_module = require("../../log_analysis_module");
var _log_analysis_module_configuration = require("../../log_analysis_module_configuration");
var _log_analysis_module_definition = require("../../log_analysis_module_definition");
var _module_descriptor = require("./module_descriptor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogEntryRateModule = ({
  indexPattern,
  logViewId,
  spaceId,
  idFormat,
  timestampField,
  runtimeMappings
}) => {
  const sourceConfiguration = (0, _react.useMemo)(() => ({
    indices: indexPattern.split(','),
    sourceId: logViewId,
    spaceId,
    timestampField,
    runtimeMappings
  }), [indexPattern, logViewId, spaceId, timestampField, runtimeMappings]);
  const logAnalysisModule = (0, _log_analysis_module.useLogAnalysisModule)({
    moduleDescriptor: _module_descriptor.logEntryRateModule,
    idFormat,
    sourceConfiguration
  });
  const {
    getIsJobConfigurationOutdated
  } = (0, _log_analysis_module_configuration.useLogAnalysisModuleConfiguration)({
    sourceConfiguration,
    moduleDescriptor: _module_descriptor.logEntryRateModule
  });
  const {
    fetchModuleDefinition,
    getIsJobDefinitionOutdated
  } = (0, _log_analysis_module_definition.useLogAnalysisModuleDefinition)({
    sourceConfiguration,
    idFormat,
    moduleDescriptor: _module_descriptor.logEntryRateModule
  });
  const hasOutdatedJobConfigurations = (0, _react.useMemo)(() => logAnalysisModule.jobSummaries.some(getIsJobConfigurationOutdated), [getIsJobConfigurationOutdated, logAnalysisModule.jobSummaries]);
  const hasOutdatedJobDefinitions = (0, _react.useMemo)(() => logAnalysisModule.jobSummaries.some(getIsJobDefinitionOutdated), [getIsJobDefinitionOutdated, logAnalysisModule.jobSummaries]);
  const hasStoppedJobs = (0, _react.useMemo)(() => Object.values(logAnalysisModule.jobStatus).some(currentJobStatus => currentJobStatus === 'stopped'), [logAnalysisModule.jobStatus]);
  return {
    ...logAnalysisModule,
    fetchModuleDefinition,
    hasOutdatedJobConfigurations,
    hasOutdatedJobDefinitions,
    hasStoppedJobs
  };
};
exports.useLogEntryRateModule = useLogEntryRateModule;
const [LogEntryRateModuleProvider, useLogEntryRateModuleContext] = (0, _constate.default)(useLogEntryRateModule);
exports.useLogEntryRateModuleContext = useLogEntryRateModuleContext;
exports.LogEntryRateModuleProvider = LogEntryRateModuleProvider;