"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsDeprecationCallout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _routerUtils = require("@kbn/router-utils");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _uiTheme = require("@kbn/ui-theme");
var _css = require("@emotion/css");
var _use_kibana = require("../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DISMISSAL_STORAGE_KEY = 'log_stream_deprecation_callout_dismissed';
const LogsDeprecationCallout = () => {
  const {
    services: {
      share
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [isDismissed, setDismissed] = (0, _useLocalStorage.default)(DISMISSAL_STORAGE_KEY, false);
  if (isDismissed) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.infra.logsDeprecationCallout.euiCallOut.discoverANewLogLabel', {
      defaultMessage: "There's a new, better way to explore your logs!"
    }),
    color: "warning",
    iconType: "iInCircle",
    heading: "h2",
    onDismiss: () => setDismissed(true),
    className: calloutStyle
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.infra.logsDeprecationCallout.p.theNewLogsExplorerLabel', {
    defaultMessage: 'The new Logs Explorer makes viewing and inspecting your logs easier with more features, better performance, and more intuitive navigation. We recommend switching to Logs Explorer, as it will replace Logs Stream in a future version.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    fill: true,
    "data-test-subj": "infraLogsDeprecationCalloutTryLogsExplorerButton",
    color: "warning"
  }, getLogsExplorerLinkProps(share)), _i18n.i18n.translate('xpack.infra.logsDeprecationCallout.tryLogsExplorerButtonLabel', {
    defaultMessage: 'Try Logs Explorer'
  })));
};
exports.LogsDeprecationCallout = LogsDeprecationCallout;
const getLogsExplorerLinkProps = share => {
  const locator = share.url.locators.get(_deeplinksObservability.ALL_DATASETS_LOCATOR_ID);
  return (0, _routerUtils.getRouterLinkProps)({
    href: locator.getRedirectUrl({}),
    onClick: () => locator.navigate({})
  });
};
const calloutStyle = (0, _css.css)`
  margin-bottom: ${_uiTheme.euiThemeVars.euiSizeL};
`;