"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogStreamEmbeddableProviders = void 0;
exports.getLogStreamEmbeddableFactory = getLogStreamEmbeddableFactory;
var _react = _interopRequireWildcard(require("react"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/logs-shared-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _datemath = require("../../utils/datemath");
var _constants = require("./constants");
var _use_kibana = require("../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLogStreamEmbeddableFactory(services) {
  const factory = {
    type: _constants.LOG_STREAM_EMBEDDABLE,
    deserializeState: state => state.rawState,
    buildEmbeddable: async (state, buildApi) => {
      const timeRangeContext = (0, _presentationPublishing.initializeTimeRange)(state);
      const {
        titlesApi,
        titleComparators,
        serializeTitles
      } = (0, _presentationPublishing.initializeTitles)(state);
      const api = buildApi({
        ...timeRangeContext.api,
        ...titlesApi,
        serializeState: () => {
          return {
            rawState: {
              ...timeRangeContext.serialize(),
              ...serializeTitles()
            }
          };
        }
      }, {
        ...timeRangeContext.comparators,
        ...titleComparators
      });
      return {
        api,
        Component: () => {
          const {
            filters,
            query,
            timeRange
          } = (0, _presentationPublishing.useFetchContext)(api);
          const {
            startTimestamp,
            endTimestamp
          } = (0, _react.useMemo)(() => {
            return {
              startTimestamp: timeRange ? (0, _datemath.datemathToEpochMillis)(timeRange.from) : undefined,
              endTimestamp: timeRange ? (0, _datemath.datemathToEpochMillis)(timeRange.to, 'up') : undefined
            };
          }, [timeRange]);
          const [darkMode, setDarkMode] = (0, _react.useState)(false);
          (0, _react.useEffect)(() => {
            const subscription = services.coreStart.theme.theme$.subscribe(theme => {
              setDarkMode(theme.darkMode);
            });
            return () => subscription.unsubscribe();
          }, []);
          return !startTimestamp || !endTimestamp ? null : /*#__PURE__*/_react.default.createElement(LogStreamEmbeddableProviders, {
            core: services.coreStart,
            plugins: services.pluginDeps,
            pluginStart: services.pluginStart,
            theme$: services.coreStart.theme.theme$
          }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
            darkMode: darkMode
          }, /*#__PURE__*/_react.default.createElement("div", {
            style: {
              width: '100%'
            }
          }, /*#__PURE__*/_react.default.createElement(_public.LogStream, {
            logView: {
              type: 'log-view-reference',
              logViewId: 'default'
            },
            startTimestamp: startTimestamp,
            endTimestamp: endTimestamp,
            height: "100%",
            query: query,
            filters: filters
          }))));
        }
      };
    }
  };
  return factory;
}
const LogStreamEmbeddableProviders = ({
  children,
  core,
  pluginStart,
  plugins
}) => {
  const KibanaContextProviderForPlugin = (0, _use_kibana.useKibanaContextForPluginProvider)(core, plugins, pluginStart);
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement(KibanaContextProviderForPlugin, {
    services: {
      ...core,
      ...plugins,
      ...pluginStart
    }
  }, children));
};
exports.LogStreamEmbeddableProviders = LogStreamEmbeddableProviders;