"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Page = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _use_metrics_breadcrumbs = require("../../../hooks/use_metrics_breadcrumbs");
var _use_parent_breadcrumb_resolver = require("../../../hooks/use_parent_breadcrumb_resolver");
var _use_kibana = require("../../../hooks/use_kibana");
var _loading = require("../../loading");
var _constants = require("../constants");
var _content = require("../content/content");
var _use_asset_details_render_props = require("../hooks/use_asset_details_render_props");
var _use_metadata_state = require("../hooks/use_metadata_state");
var _use_page_header = require("../hooks/use_page_header");
var _use_tab_switcher = require("../hooks/use_tab_switcher");
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Page = ({
  tabs = [],
  links = []
}) => {
  const {
    loading
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    metadata,
    loading: metadataLoading
  } = (0, _use_metadata_state.useMetadataStateContext)();
  const {
    rightSideItems,
    tabEntries,
    breadcrumbs: headerBreadcrumbs
  } = (0, _use_page_header.usePageHeader)(tabs, links);
  const {
    asset
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const trackOnlyOnce = _react2.default.useRef(false);
  const {
    activeTabId
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    services: {
      telemetry,
      observabilityShared: {
        navigation: {
          PageTemplate
        }
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const parentBreadcrumbResolver = (0, _use_parent_breadcrumb_resolver.useParentBreadcrumbResolver)();
  const breadcrumbOptions = parentBreadcrumbResolver.getBreadcrumbOptions(asset.type);
  (0, _use_metrics_breadcrumbs.useMetricsBreadcrumbs)([{
    ...breadcrumbOptions.link,
    text: breadcrumbOptions.text
  }, {
    text: asset.name
  }], {
    deeperContextServerless: true
  });
  (0, _react2.useEffect)(() => {
    if (trackOnlyOnce.current) {
      return;
    }
    if (!metadataLoading && metadata) {
      const integrations = (0, _utils.getIntegrationsAvailable)(metadata);
      const telemetryParams = {
        componentName: _constants.ASSET_DETAILS_PAGE_COMPONENT_NAME,
        assetType: asset.type,
        tabId: activeTabId
      };
      telemetry.reportAssetDetailsPageViewed(integrations.length > 0 ? {
        ...telemetryParams,
        integrations
      } : telemetryParams);
      trackOnlyOnce.current = true;
    }
  }, [activeTabId, asset.type, metadata, metadataLoading, telemetry]);
  return /*#__PURE__*/_react2.default.createElement(PageTemplate, {
    pageHeader: {
      pageTitle: asset.name,
      tabs: tabEntries,
      rightSideItems,
      breadcrumbs: headerBreadcrumbs
    },
    "data-component-name": _constants.ASSET_DETAILS_PAGE_COMPONENT_NAME,
    "data-asset-type": asset.type
  }, loading ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    css: (0, _react.css)`
            height: calc(100vh - var(--kbnAppHeadersOffset, var(--euiFixedHeadersOffset, 0)));
          `
  }, /*#__PURE__*/_react2.default.createElement(_loading.InfraLoadingPanel, {
    height: "100%",
    width: "auto",
    text: _i18n.i18n.translate('xpack.infra.waffle.loadingDataText', {
      defaultMessage: 'Loading data'
    })
  })) : /*#__PURE__*/_react2.default.createElement(_content.Content, null));
};
exports.Page = Page;