"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServicesContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/observability-shared-plugin/public");
var _section = require("../../components/section");
var _section_titles = require("./section_titles");
var _use_services = require("../../hooks/use_services");
var _constants = require("../../../../../common/constants");
var _links = require("../../links");
var _constants2 = require("../../constants");
var _link_to_apm_service = require("../../links/link_to_apm_service");
var _use_kibana = require("../../../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ServicesContent = ({
  hostName,
  dateRange
}) => {
  const {
    isServerlessEnv
  } = (0, _use_kibana.useKibanaEnvironmentContext)();
  const linkProps = (0, _public.useLinkProps)({
    app: 'home',
    hash: '/tutorial/apm'
  });
  const serverlessLinkProps = (0, _public.useLinkProps)({
    app: 'apm',
    pathname: '/onboarding'
  });
  const params = (0, _react.useMemo)(() => ({
    filters: {
      [_constants.HOST_NAME_FIELD]: hostName
    },
    from: dateRange.from,
    to: dateRange.to
  }), [hostName, dateRange.from, dateRange.to]);
  const {
    error,
    loading,
    response
  } = (0, _use_services.useServices)(params);
  const services = response === null || response === void 0 ? void 0 : response.services;
  const hasServices = services === null || services === void 0 ? void 0 : services.length;
  return /*#__PURE__*/_react.default.createElement(_section.Section, {
    title: /*#__PURE__*/_react.default.createElement(_section_titles.ServicesSectionTitle, null),
    collapsible: true,
    "data-test-subj": "infraAssetDetailsServicesCollapsible",
    id: "services",
    extraAction: /*#__PURE__*/_react.default.createElement(_links.LinkToApmServices, {
      assetId: hostName,
      apmField: _constants2.APM_HOST_FILTER_FIELD
    })
  }, error ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.infra.assetDetails.services.getServicesRequestErrorTitle', {
      defaultMessage: 'Error'
    }),
    color: "danger",
    iconType: "alert"
  }, _i18n.i18n.translate('xpack.infra.assetDetails.services.getServicesRequestError', {
    defaultMessage: 'An error occurred while fetching services.'
  })) : loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }) : hasServices ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    responsive: false,
    gutterSize: "xs",
    "data-test-subj": "infraAssetDetailsServicesContainer"
  }, services.map((service, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: index
  }, /*#__PURE__*/_react.default.createElement(_link_to_apm_service.LinkToApmService, {
    serviceName: service.serviceName,
    agentName: service.agentName,
    dateRange: dateRange
  })))) : /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.services.noServicesMsg",
    defaultMessage: "No services found on this host. Click {apmTutorialLink} to instrument your services with APM.",
    values: {
      apmTutorialLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "assetDetailsTooltiAPMTutorialLink",
        href: isServerlessEnv ? serverlessLinkProps.href : linkProps.href
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.table.services.noServices.tutorialLink",
        defaultMessage: "here"
      }))
    }
  })));
};
exports.ServicesContent = ServicesContent;