"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRowsWithPins = exports.getAllFields = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAllFields = metadata => {
  var _metadata$info$agent, _metadata$info$cloud, _metadata$info$host, _metadata$info3, _metadata$info$contai, _metadata$info4;
  if (!(metadata !== null && metadata !== void 0 && metadata.info)) return [];
  const mapNestedProperties = (category, property) => {
    var _metadata$info, _metadata$info2;
    const fieldsByCategory = (_metadata$info = metadata === null || metadata === void 0 ? void 0 : (_metadata$info2 = metadata.info) === null || _metadata$info2 === void 0 ? void 0 : _metadata$info2[`${category}`]) !== null && _metadata$info !== void 0 ? _metadata$info : {};
    if (fieldsByCategory.hasOwnProperty(property)) {
      const value = fieldsByCategory[property];
      if (typeof value === 'boolean') {
        return {
          name: `${category}.${property}`,
          value: String(value)
        };
      }
      if (typeof value === 'string' || Array.isArray(value)) {
        return {
          name: `${category}.${property}`,
          value
        };
      } else {
        return Object.entries(value !== null && value !== void 0 ? value : {}).map(([prop, subProp]) => {
          if (!Array.isArray(subProp) && (0, _lodash.isPlainObject)(subProp)) {
            return {
              name: '',
              value: ''
            };
          }
          return {
            name: `${category}.${property}.${prop}`,
            value: subProp
          };
        }).filter(({
          name
        }) => name);
      }
    }
    return [];
  };
  const agent = Object.keys((_metadata$info$agent = metadata.info.agent) !== null && _metadata$info$agent !== void 0 ? _metadata$info$agent : {}).flatMap(prop => mapNestedProperties('agent', prop));
  const cloud = Object.keys((_metadata$info$cloud = metadata.info.cloud) !== null && _metadata$info$cloud !== void 0 ? _metadata$info$cloud : {}).flatMap(prop => mapNestedProperties('cloud', prop));
  const host = Object.keys((_metadata$info$host = metadata === null || metadata === void 0 ? void 0 : (_metadata$info3 = metadata.info) === null || _metadata$info3 === void 0 ? void 0 : _metadata$info3.host) !== null && _metadata$info$host !== void 0 ? _metadata$info$host : {}).flatMap(prop => mapNestedProperties('host', prop));
  const container = Object.keys((_metadata$info$contai = metadata === null || metadata === void 0 ? void 0 : (_metadata$info4 = metadata.info) === null || _metadata$info4 === void 0 ? void 0 : _metadata$info4.container) !== null && _metadata$info$contai !== void 0 ? _metadata$info$contai : {}).flatMap(prop => mapNestedProperties('container', prop));
  return prune([...host, ...container, ...agent, ...cloud]);
};
exports.getAllFields = getAllFields;
const prune = fields => fields.filter(f => !!(f !== null && f !== void 0 && f.value));
const getRowsWithPins = (rows, pinnedItems) => {
  if (pinnedItems.length > 0) {
    const {
      pinned,
      other
    } = rows.reduce((acc, row) => {
      (pinnedItems.includes(row.name) ? acc.pinned : acc.other).push(row);
      return acc;
    }, {
      pinned: [],
      other: []
    });
    return [...pinned, ...other];
  }
};
exports.getRowsWithPins = getRowsWithPins;