"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabSwitcherProvider = exports.TabSwitcher = void 0;
exports.useTabSwitcher = useTabSwitcher;
exports.useTabSwitcherContext = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _use_lazy_ref = require("../../../hooks/use_lazy_ref");
var _use_asset_details_url_state = require("./use_asset_details_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useTabSwitcher({
  defaultActiveTabId
}) {
  var _urlState$tabId$split, _urlState$tabId;
  const [urlState, setUrlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const [activeTabId = defaultActiveTabId, scrollTo] = (_urlState$tabId$split = urlState === null || urlState === void 0 ? void 0 : (_urlState$tabId = urlState.tabId) === null || _urlState$tabId === void 0 ? void 0 : _urlState$tabId.split('#')) !== null && _urlState$tabId$split !== void 0 ? _urlState$tabId$split : [];

  // This set keeps track of which tabs content have been rendered the first time.
  // We need it in order to load a tab content only if it gets clicked, and then keep it in the DOM for performance improvement.
  const renderedTabsSet = (0, _use_lazy_ref.useLazyRef)(() => new Set([activeTabId]));
  const showTab = (tabId, options) => {
    // On a tab click, mark the tab content as allowed to be rendered
    renderedTabsSet.current.add(tabId);
    setUrlState({
      tabId: options !== null && options !== void 0 && options.scrollTo ? `${tabId}#${options === null || options === void 0 ? void 0 : options.scrollTo}` : tabId
    });
  };
  const setScrollTo = to => {
    showTab(activeTabId, {
      scrollTo: to
    });
  };
  return {
    activeTabId,
    scrollTo,
    renderedTabsSet,
    showTab,
    setScrollTo
  };
}
const TabSwitcher = exports.TabSwitcher = (0, _constate.default)(useTabSwitcher);
const [TabSwitcherProvider, useTabSwitcherContext] = TabSwitcher;
exports.useTabSwitcherContext = useTabSwitcherContext;
exports.TabSwitcherProvider = TabSwitcherProvider;