"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProfilingFlamegraphData = useProfilingFlamegraphData;
var _react = require("react");
var _use_http_request = require("../../../hooks/use_http_request");
var _use_request_observable = require("./use_request_observable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useProfilingFlamegraphData({
  params,
  isActive
}) {
  const {
    request$
  } = (0, _use_request_observable.useRequestObservable)();
  const fetchOptions = (0, _react.useMemo)(() => ({
    query: params
  }), [params]);
  const {
    loading,
    error,
    response,
    makeRequest
  } = (0, _use_http_request.useHTTPRequest)(`/api/infra/profiling/flamegraph`, 'GET', undefined, undefined, undefined, undefined, true, fetchOptions);
  (0, _react.useEffect)(() => {
    if (!isActive) {
      return;
    }
    request$.next(makeRequest);
  }, [isActive, makeRequest, request$]);
  return {
    loading,
    error,
    response
  };
}