"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessListContextProvider = void 0;
exports.useProcessList = useProcessList;
exports.useProcessListContext = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _pipeable = require("fp-ts/lib/pipeable");
var _react = require("react");
var _http_api = require("../../../../common/http_api");
var _runtime_types = require("../../../../common/runtime_types");
var _use_http_request = require("../../../hooks/use_http_request");
var _metrics_source = require("../../../containers/metrics_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useProcessList(hostTerm, to, sortBy, searchFilter, request$) {
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const decodeResponse = response => {
    return (0, _pipeable.pipe)(_http_api.ProcessListAPIResponseRT.decode(response), (0, _Either.fold)((0, _runtime_types.throwErrors)(_runtime_types.createPlainError), _function.identity));
  };
  const parsedSortBy = sortBy.name === 'runtimeLength' ? {
    ...sortBy,
    name: 'startTime'
  } : sortBy;
  const {
    error,
    loading,
    response,
    makeRequest
  } = (0, _use_http_request.useHTTPRequest)('/api/metrics/process_list', 'POST', JSON.stringify({
    hostTerm,
    indexPattern: metricsView === null || metricsView === void 0 ? void 0 : metricsView.indices,
    to,
    sortBy: parsedSortBy,
    searchFilter
  }), decodeResponse, undefined, undefined, true);
  (0, _react.useEffect)(() => {
    if (request$) {
      request$.next(makeRequest);
    } else {
      makeRequest();
    }
  }, [makeRequest, request$]);
  return {
    error: error && error.message || null,
    loading,
    response,
    makeRequest
  };
}
function useProcessListParams(props) {
  const {
    hostTerm,
    to
  } = props;
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  return {
    hostTerm,
    indexPattern: metricsView === null || metricsView === void 0 ? void 0 : metricsView.indices,
    to
  };
}
const ProcessListContext = (0, _constate.default)(useProcessListParams);
const [ProcessListContextProvider, useProcessListContext] = ProcessListContext;
exports.useProcessListContext = useProcessListContext;
exports.ProcessListContextProvider = ProcessListContextProvider;