"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMetadata = useMetadata;
var _react = require("react");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _pipeable = require("fp-ts/lib/pipeable");
var _use_http_request = require("../../../hooks/use_http_request");
var _metadata_api = require("../../../../common/http_api/metadata_api");
var _runtime_types = require("../../../../common/runtime_types");
var _get_filtered_metrics = require("../../../pages/metrics/metric_detail/lib/get_filtered_metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMetadata({
  assetId,
  assetType,
  sourceId,
  timeRange,
  requiredMetrics = [],
  request$
}) {
  var _response$info, _response$info$cloud, _response$info$cloud$;
  const decodeResponse = response => {
    return (0, _pipeable.pipe)(_metadata_api.InfraMetadataRT.decode(response), (0, _Either.fold)((0, _runtime_types.throwErrors)(_runtime_types.createPlainError), _function.identity));
  };
  const {
    error,
    loading,
    response,
    makeRequest
  } = (0, _use_http_request.useHTTPRequest)('/api/infra/metadata', 'POST', JSON.stringify({
    nodeId: assetId,
    nodeType: assetType,
    sourceId,
    timeRange
  }), decodeResponse, undefined, undefined, true);
  (0, _react.useEffect)(() => {
    if (request$) {
      request$.next(makeRequest);
    } else {
      makeRequest();
    }
  }, [makeRequest, request$]);
  return {
    name: response && response.name || '',
    filteredRequiredMetrics: response && requiredMetrics.length > 0 ? (0, _get_filtered_metrics.getFilteredMetrics)(requiredMetrics, response.features) : [],
    error: error && error.message || null,
    loading,
    metadata: response,
    cloudId: (response === null || response === void 0 ? void 0 : (_response$info = response.info) === null || _response$info === void 0 ? void 0 : (_response$info$cloud = _response$info.cloud) === null || _response$info$cloud === void 0 ? void 0 : (_response$info$cloud$ = _response$info$cloud.instance) === null || _response$info$cloud$ === void 0 ? void 0 : _response$info$cloud$.id) || '',
    reload: makeRequest
  };
}