"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKubernetesCharts = exports.useHostKpiCharts = exports.useHostCharts = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _react = require("react");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHostCharts = ({
  metric,
  dataViewId,
  overview
}) => {
  const {
    value: charts = [],
    error
  } = (0, _useAsync.default)(async () => {
    const hostCharts = await getHostsCharts({
      metric,
      overview
    });
    return hostCharts.map(chart => ({
      ...chart,
      ...(dataViewId && {
        dataset: {
          index: dataViewId
        }
      })
    }));
  }, [dataViewId, metric, overview]);
  return {
    charts,
    error
  };
};
exports.useHostCharts = useHostCharts;
const useKubernetesCharts = ({
  dataViewId,
  overview
}) => {
  const model = (0, _react.useMemo)(() => (0, _common.findInventoryModel)('host'), []);
  const {
    value: charts = [],
    error
  } = (0, _useAsync.default)(async () => {
    const {
      kibernetesNode
    } = await model.metrics.getCharts();
    const items = overview ? [kibernetesNode.xy.nodeCpuCapacity, kibernetesNode.xy.nodeMemoryCapacity] : [kibernetesNode.xy.nodeCpuCapacity, kibernetesNode.xy.nodeMemoryCapacity, kibernetesNode.xy.nodeDiskCapacity, kibernetesNode.xy.nodePodCapacity];
    return items.map(chart => {
      return {
        ...chart,
        ...(dataViewId && {
          dataset: {
            index: dataViewId
          }
        })
      };
    });
  }, [dataViewId, overview, model.metrics]);
  return {
    charts,
    error
  };
};
exports.useKubernetesCharts = useKubernetesCharts;
const getSubtitleFromFormula = value => value.startsWith('max') ? _i18n.i18n.translate('xpack.infra.hostsViewPage.kpi.subtitle.max', {
  defaultMessage: 'Max'
}) : _i18n.i18n.translate('xpack.infra.assetDetails.kpi.subtitle.average', {
  defaultMessage: 'Average'
});
const useHostKpiCharts = ({
  dataViewId,
  seriesColor,
  getSubtitle
}) => {
  const {
    value: charts = []
  } = (0, _useAsync.default)(async () => {
    const model = (0, _common.findInventoryModel)('host');
    const {
      cpu,
      memory,
      disk
    } = await model.metrics.getCharts();
    return [cpu.metric.cpuUsage, cpu.metric.normalizedLoad1m, memory.metric.memoryUsage, disk.metric.diskUsage].map(chart => ({
      ...chart,
      seriesColor,
      decimals: 1,
      subtitle: getSubtitle ? getSubtitle(chart.value) : getSubtitleFromFormula(chart.value),
      ...(dataViewId && {
        dataset: {
          index: dataViewId
        }
      })
    }));
  }, [dataViewId, seriesColor, getSubtitle]);
  return charts;
};
exports.useHostKpiCharts = useHostKpiCharts;
const getHostsCharts = async ({
  metric,
  overview
}) => {
  const model = (0, _common.findInventoryModel)('host');
  const {
    cpu,
    memory,
    network,
    disk,
    logs
  } = await model.metrics.getCharts();
  switch (metric) {
    case 'cpu':
      return overview ? [cpu.xy.cpuUsage, cpu.xy.normalizedLoad1m] : [cpu.xy.cpuUsage, cpu.xy.cpuUsageBreakdown, cpu.xy.normalizedLoad1m, cpu.xy.loadBreakdown];
    case 'memory':
      return overview ? [memory.xy.memoryUsage] : [memory.xy.memoryUsage, memory.xy.memoryUsageBreakdown];
    case 'network':
      return [network.xy.rxTx];
    case 'disk':
      return overview ? [disk.xy.diskUsageByMountPoint, disk.xy.diskIOReadWrite] : [disk.xy.diskUsageByMountPoint, disk.xy.diskIOReadWrite, disk.xy.diskThroughputReadWrite];
    case 'log':
      return [logs.xy.logRate];
    default:
      return [];
  }
};