"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssetDetailsUrlState = exports.DEFAULT_STATE = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _react = require("react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _types = require("../types");
var _use_url_state = require("../../../utils/use_url_state");
var _constants = require("../constants");
var _constants2 = require("../../shared/alerts/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_STATE = exports.DEFAULT_STATE = {
  tabId: _types.ContentTabIds.OVERVIEW
};
const useAssetDetailsUrlState = () => {
  const [urlState, setUrlState] = (0, _use_url_state.useUrlState)({
    defaultState: null,
    decodeUrlState,
    encodeUrlState,
    urlStateKey: _constants.ASSET_DETAILS_URL_STATE_KEY
  });
  const setAssetDetailsState = (0, _react.useCallback)(newProps => {
    if (!newProps) {
      setUrlState(null);
    } else {
      const payload = Object.fromEntries(Object.entries(newProps !== null && newProps !== void 0 ? newProps : {}).filter(([_, v]) => !!v || v === ''));
      setUrlState(previous => ({
        ...previous,
        ...payload
      }));
    }
  }, [setUrlState]);
  return [urlState, setAssetDetailsState];
};
exports.useAssetDetailsUrlState = useAssetDetailsUrlState;
const TabIdRT = rt.union([rt.literal(_types.ContentTabIds.OVERVIEW), rt.literal(_types.ContentTabIds.METADATA), rt.literal(_types.ContentTabIds.METRICS), rt.literal(_types.ContentTabIds.PROCESSES), rt.literal(_types.ContentTabIds.PROFILING), rt.literal(_types.ContentTabIds.LOGS), rt.literal(_types.ContentTabIds.ANOMALIES), rt.literal(_types.ContentTabIds.OSQUERY), rt.literal(_types.ContentTabIds.DASHBOARDS)]);
const AlertStatusRT = rt.union([rt.literal(_constants2.ALERT_STATUS_ALL), rt.literal(_ruleDataUtils.ALERT_STATUS_ACTIVE), rt.literal(_ruleDataUtils.ALERT_STATUS_RECOVERED), rt.literal(_ruleDataUtils.ALERT_STATUS_UNTRACKED)]);
// Custom codec for tabId with fragment
const TabIdWithSectionRT = rt.brand(rt.string, s => s.includes('#') ? TabIdRT.is(s.split('#')[0]) : TabIdRT.is(s), 'TabIdWithSection');
const AssetDetailsUrlStateRT = rt.partial({
  autoRefresh: rt.partial({
    isPaused: rt.boolean,
    interval: rt.number
  }),
  dateRange: rt.type({
    from: rt.string,
    to: rt.string
  }),
  tabId: TabIdWithSectionRT,
  name: rt.string,
  processSearch: rt.string,
  metadataSearch: rt.string,
  logsSearch: rt.string,
  profilingSearch: rt.string,
  alertStatus: AlertStatusRT,
  dashboardId: rt.string
});
const AssetDetailsUrlRT = rt.union([AssetDetailsUrlStateRT, rt.null]);
const encodeUrlState = AssetDetailsUrlRT.encode;
const decodeUrlState = value => {
  return (0, _pipeable.pipe)(AssetDetailsUrlRT.decode(value), (0, _Either.fold)((0, _function.constant)(undefined), _function.identity));
};