"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KUBERNETES_METRIC_TYPES = exports.INTEGRATIONS = exports.DOCKER_METRIC_TYPES = exports.ASSET_DETAILS_URL_STATE_KEY = exports.ASSET_DETAILS_PAGE_COMPONENT_NAME = exports.ASSET_DETAILS_FLYOUT_COMPONENT_NAME = exports.APM_HOST_FILTER_FIELD = exports.APM_FILTER_FIELD_PER_ASSET_TYPE = exports.APM_CONTAINER_FILTER_FIELD = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASSET_DETAILS_FLYOUT_COMPONENT_NAME = exports.ASSET_DETAILS_FLYOUT_COMPONENT_NAME = 'infraAssetDetailsFlyout';
const ASSET_DETAILS_PAGE_COMPONENT_NAME = exports.ASSET_DETAILS_PAGE_COMPONENT_NAME = 'infraAssetDetailsPage';
const APM_HOST_FILTER_FIELD = exports.APM_HOST_FILTER_FIELD = 'host.hostname';
const APM_CONTAINER_FILTER_FIELD = exports.APM_CONTAINER_FILTER_FIELD = 'container.id';
const APM_FILTER_FIELD_PER_ASSET_TYPE = exports.APM_FILTER_FIELD_PER_ASSET_TYPE = {
  [_types.ASSET_DETAILS_ASSET_TYPE.container]: APM_CONTAINER_FILTER_FIELD,
  [_types.ASSET_DETAILS_ASSET_TYPE.host]: APM_HOST_FILTER_FIELD
};
const ASSET_DETAILS_URL_STATE_KEY = exports.ASSET_DETAILS_URL_STATE_KEY = 'assetDetails';
const INTEGRATIONS = exports.INTEGRATIONS = {
  [_types.INTEGRATION_NAME.kubernetesNode]: 'kubernetes.node',
  [_types.INTEGRATION_NAME.kubernetesContainer]: 'kubernetes.container',
  [_types.INTEGRATION_NAME.docker]: 'docker'
};
const DOCKER_METRIC_TYPES = exports.DOCKER_METRIC_TYPES = ['cpu', 'memory', 'network', 'disk'];
const KUBERNETES_METRIC_TYPES = exports.KUBERNETES_METRIC_TYPES = ['cpu', 'memory'];