"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartsGrid = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartsGrid = ({
  children,
  columns
}) => {
  const childrenArray = _react.default.Children.toArray(children);
  const childrenCount = childrenArray.length;
  const {
    grid,
    lastRow
  } = _react.default.useMemo(() => {
    const isOddLength = childrenCount % columns !== 0;
    const gridItems = isOddLength ? childrenArray.slice(0, -1) : childrenArray;
    const lastRowItem = isOddLength ? childrenArray[childrenCount - 1] : undefined;
    return {
      grid: gridItems,
      lastRow: lastRowItem
    };
  }, [childrenArray, childrenCount, columns]);
  if (childrenCount === 1) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: columns,
    gutterSize: "s"
  }, grid.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, item))), lastRow && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, lastRow));
};
exports.ChartsGrid = ChartsGrid;