"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DockerCharts = void 0;
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/metrics-data-access-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _use_container_metrics_charts = require("../hooks/use_container_metrics_charts");
var _section = require("../components/section");
var _charts_grid = require("../charts_grid/charts_grid");
var _chart = require("./chart");
var _section_title = require("../components/section_title");
var _translations = require("../translations");
var _constants = require("../../../common/visualizations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FRAGMENT_BASE = 'key-metrics';
const DockerCharts = exports.DockerCharts = /*#__PURE__*/_react.default.forwardRef(({
  assetId,
  dataView,
  dateRange,
  metric,
  onShowAll
}, ref) => {
  const {
    charts
  } = (0, _use_container_metrics_charts.useDockerContainerPageViewMetricsCharts)({
    metric,
    metricsDataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id
  });
  return /*#__PURE__*/_react.default.createElement(_section.Section, {
    title: /*#__PURE__*/_react.default.createElement(_section_title.TitleWithTooltip, {
      title: _translations.CONTAINER_METRIC_GROUP_TITLES[metric],
      tooltipContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.charts.container.toolTip",
        defaultMessage: "See container-related {link} for more information",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "infraAssetDetailsViewContainerMetricsDocumentationLink",
            href: `${_constants.CONTAINER_METRICS_DOC_HREF}#${FRAGMENT_BASE}-${metric}`,
            target: "_blank",
            className: (0, _css.cx)({
              [(0, _css.css)`
                            text-transform: lowercase;
                          `]: metric !== 'cpu'
            })
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.infra.assetDetails.charts.container.toolTip.linkText",
            defaultMessage: "{metric} metrics",
            values: {
              metric: _translations.CONTAINER_METRIC_GROUP_TITLES[metric]
            }
          }))
        }
      }))
    }),
    "data-test-subj": `infraAssetDetailsDockerChartsSection${metric}`,
    id: metric,
    ref: ref,
    extraAction: onShowAll ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "infraAssetDetailsHostChartsShowAllButton",
      onClick: () => onShowAll(metric),
      size: "xs",
      flush: "both",
      iconSide: "right",
      iconType: "sortRight"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.assetDetails.charts.host.showAllButton",
      defaultMessage: "Show all"
    })) : null
  }, /*#__PURE__*/_react.default.createElement(_charts_grid.ChartsGrid, {
    columns: 2
  }, charts.map(chart => /*#__PURE__*/_react.default.createElement(_chart.Chart, {
    id: chart.id,
    key: chart.id,
    lensAttributes: chart,
    assetId: assetId,
    dateRange: dateRange,
    queryField: (0, _common.findInventoryFields)('container').id
  }))));
});