"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hostDetailsTabs = exports.hostDetailsFlyoutTabs = exports.getAssetDetailsTabs = exports.getAssetDetailsFlyoutTabs = exports.containerDetailsTabs = exports.containerDetailsFlyoutTabs = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _types = require("../../components/asset_details/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const overviewTab = {
  id: _types.ContentTabIds.OVERVIEW,
  name: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.overview.title', {
    defaultMessage: 'Overview'
  })
};
const metadataTab = {
  id: _types.ContentTabIds.METADATA,
  name: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.metadata.title', {
    defaultMessage: 'Metadata'
  })
};
const metricsTab = {
  id: _types.ContentTabIds.METRICS,
  name: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.metrics.title', {
    defaultMessage: 'Metrics'
  })
};
const processesTab = {
  id: _types.ContentTabIds.PROCESSES,
  name: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.tabs.processes', {
    defaultMessage: 'Processes'
  })
};
const profilingTab = {
  id: _types.ContentTabIds.PROFILING,
  name: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.tabs.profiling', {
    defaultMessage: 'Universal Profiling'
  })
};
const logsTab = {
  id: _types.ContentTabIds.LOGS,
  name: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.logs.title', {
    defaultMessage: 'Logs'
  })
};
const anomaliesTab = {
  id: _types.ContentTabIds.ANOMALIES,
  name: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.anomalies', {
    defaultMessage: 'Anomalies'
  })
};
const osqueryTab = {
  id: _types.ContentTabIds.OSQUERY,
  name: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.osquery', {
    defaultMessage: 'Osquery'
  })
};
const dashboardsTab = {
  id: _types.ContentTabIds.DASHBOARDS,
  name: _i18n.i18n.translate('xpack.infra.infra.nodeDetails.tabs.dashboards', {
    defaultMessage: 'Dashboards'
  }),
  append: /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.i18n.translate('xpack.infra.customDashboards.technicalPreviewBadgeLabel', {
      defaultMessage: 'Technical preview'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.infra.customDashboards.technicalPreviewBadgeDescription', {
      defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
    }),
    iconType: "beaker",
    size: "s",
    style: {
      verticalAlign: 'middle'
    }
  })
};
const linkToApmTab = {
  id: _types.ContentTabIds.LINK_TO_APM,
  name: _i18n.i18n.translate('xpack.infra.assetDetails.tabs.linkToApm', {
    defaultMessage: 'APM'
  })
};
const hostDetailsTabs = exports.hostDetailsTabs = [overviewTab, metadataTab, metricsTab, processesTab, profilingTab, logsTab, anomaliesTab, osqueryTab, dashboardsTab];
const hostDetailsFlyoutTabs = exports.hostDetailsFlyoutTabs = [...hostDetailsTabs, linkToApmTab];

// The profiling tab would be added in next iteration
const containerDetailsTabs = exports.containerDetailsTabs = [overviewTab, metadataTab, metricsTab, logsTab];
const containerDetailsFlyoutTabs = exports.containerDetailsFlyoutTabs = [overviewTab, metadataTab, metricsTab, logsTab, linkToApmTab];
const getAssetDetailsTabs = type => {
  switch (type) {
    case 'host':
      return hostDetailsTabs;
    case 'container':
      return containerDetailsTabs;
    default:
      return [];
  }
};
exports.getAssetDetailsTabs = getAssetDetailsTabs;
const getAssetDetailsFlyoutTabs = type => {
  switch (type) {
    case 'host':
      return hostDetailsFlyoutTabs;
    case 'container':
      return containerDetailsFlyoutTabs;
    default:
      return [];
  }
};
exports.getAssetDetailsFlyoutTabs = getAssetDetailsFlyoutTabs;