"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = renderApp;
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _history = require("history");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This exists purely to facilitate legacy app/infra URL redirects.
// It will be removed in 8.0.0.
async function renderApp(core, {
  element
}) {
  const history = (0, _history.createBrowserHistory)();
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement(LegacyApp, {
    history: history
  })), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
}
const LegacyApp = ({
  history
}) => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: '/',
    render: ({
      location
    }) => {
      if (!location) {
        return null;
      }
      let nextPath = '';
      let nextBasePath = '';
      let nextSearch;
      if (location.hash.indexOf('#infrastructure') > -1 || location.hash.indexOf('#/infrastructure') > -1) {
        nextPath = location.hash.replace(new RegExp('#infrastructure/|#/infrastructure/|#/infrastructure|#infrastructure', 'g'), '');
        nextBasePath = location.pathname.replace('app/infra', 'app/metrics');
      } else if (location.hash.indexOf('#logs') > -1 || location.hash.indexOf('#/logs') > -1) {
        nextPath = location.hash.replace(new RegExp('#logs/|#/logs/|#/logs|#logs', 'g'), '');
        nextBasePath = location.pathname.replace('app/infra', 'app/logs');
      } else {
        // This covers /app/infra and /app/infra/home (both of which used to render
        // the metrics inventory page)
        nextPath = 'inventory';
        nextBasePath = location.pathname.replace('app/infra', 'app/metrics');
        nextSearch = undefined;
      }

      // app/infra#infrastructure/metrics/:type/:node was changed to app/metrics/detail/:type/:node, this
      // accounts for that edge case
      nextPath = nextPath.replace('metrics/', 'detail/');

      // Query parameters (location.search) will arrive as part of location.hash and not location.search
      const nextPathParts = nextPath.split('?');
      nextPath = nextPathParts[0];
      nextSearch = nextPathParts[1] ? nextPathParts[1] : undefined;
      const builtPathname = `${nextBasePath}/${nextPath}`;
      const builtSearch = nextSearch ? `?${nextSearch}` : '';
      let nextUrl = `${builtPathname}${builtSearch}`;
      nextUrl = nextUrl.replace('//', '/');
      window.location.href = nextUrl;
      return null;
    }
  })));
};