"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInventoryAlertPrefill = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInventoryAlertPrefill = () => {
  const [nodeType, setNodeType] = (0, _react.useState)('host');
  const [filterQuery, setFilterQuery] = (0, _react.useState)();
  const [metric, setMetric] = (0, _react.useState)({
    type: 'cpu'
  });
  const [customMetrics, setCustomMetrics] = (0, _react.useState)([]);
  // only shows for AWS when there are regions info
  const [region, setRegion] = (0, _react.useState)('');
  // only shows for AWS when there are accounts info
  const [accountId, setAccountId] = (0, _react.useState)('');
  return {
    nodeType,
    filterQuery,
    metric,
    customMetrics,
    accountId,
    region,
    setAccountId,
    setNodeType,
    setFilterQuery,
    setMetric,
    setCustomMetrics,
    setRegion
  };
};
exports.useInventoryAlertPrefill = useInventoryAlertPrefill;