"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricExpression = exports.ClosablePopoverTitle = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _metrics_source = require("../../../containers/metrics_source");
var _get_custom_metric_label = require("../../../../common/formatters/get_custom_metric_label");
var _snapshot_api = require("../../../../common/http_api/snapshot_api");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGGREGATION_LABELS = {
  ['avg']: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.aggregationLables.avg', {
    defaultMessage: 'Average'
  }),
  ['max']: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.aggregationLables.max', {
    defaultMessage: 'Max'
  }),
  ['min']: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.aggregationLables.min', {
    defaultMessage: 'Min'
  }),
  ['rate']: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.aggregationLables.rate', {
    defaultMessage: 'Rate'
  })
};
const aggregationOptions = _snapshot_api.SNAPSHOT_CUSTOM_AGGREGATIONS.map(k => ({
  text: AGGREGATION_LABELS[k],
  value: k
}));
const MetricExpression = ({
  metric,
  metrics,
  customMetric,
  errors,
  onChange,
  onChangeCustom,
  popupPosition
}) => {
  var _errors$metric;
  const [popoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const [customMetricTabOpen, setCustomMetricTabOpen] = (0, _react.useState)((metric === null || metric === void 0 ? void 0 : metric.value) === 'custom');
  const [selectedOption, setSelectedOption] = (0, _react.useState)(metric === null || metric === void 0 ? void 0 : metric.value);
  const [fieldDisplayedCustomLabel, setFieldDisplayedCustomLabel] = (0, _react.useState)(customMetric === null || customMetric === void 0 ? void 0 : customMetric.label);
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const firstFieldOption = {
    text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.metric.selectFieldLabel', {
      defaultMessage: 'Select a metric'
    }),
    value: ''
  };
  const fieldOptions = (0, _react.useMemo)(() => {
    var _metricsView$fields;
    return ((_metricsView$fields = metricsView === null || metricsView === void 0 ? void 0 : metricsView.fields) !== null && _metricsView$fields !== void 0 ? _metricsView$fields : []).filter(f => f.aggregatable && f.type === 'number' && !((customMetric === null || customMetric === void 0 ? void 0 : customMetric.field) === f.name)).map(f => ({
      label: f.name
    }));
  }, [metricsView === null || metricsView === void 0 ? void 0 : metricsView.fields, customMetric === null || customMetric === void 0 ? void 0 : customMetric.field]);
  const expressionDisplayValue = (0, _react.useMemo)(() => {
    return customMetricTabOpen ? (customMetric === null || customMetric === void 0 ? void 0 : customMetric.field) && (0, _get_custom_metric_label.getCustomMetricLabel)(customMetric) : (metric === null || metric === void 0 ? void 0 : metric.text) || firstFieldOption.text;
  }, [customMetricTabOpen, metric, customMetric, firstFieldOption]);
  const onChangeTab = (0, _react.useCallback)(id => {
    if (id === 'metric-popover-custom') {
      setCustomMetricTabOpen(true);
      onChange('custom');
    } else {
      setCustomMetricTabOpen(false);
      onChange(selectedOption);
    }
  }, [setCustomMetricTabOpen, onChange, selectedOption]);
  const onAggregationChange = (0, _react.useCallback)(e => {
    const value = e.target.value;
    const aggValue = _snapshot_api.SnapshotCustomAggregationRT.is(value) ? value : 'avg';
    const newCustomMetric = {
      ...customMetric,
      aggregation: aggValue
    };
    if (_snapshot_api.SnapshotCustomMetricInputRT.is(newCustomMetric)) onChangeCustom(newCustomMetric);
  }, [customMetric, onChangeCustom]);
  const onFieldChange = (0, _react.useCallback)(selectedOptions => {
    const newCustomMetric = {
      ...customMetric,
      field: selectedOptions[0].label
    };
    if (_snapshot_api.SnapshotCustomMetricInputRT.is(newCustomMetric)) onChangeCustom(newCustomMetric);
  }, [customMetric, onChangeCustom]);
  const debouncedOnChangeCustom = (0, _lodash.debounce)(onChangeCustom, 500);
  const onLabelChange = (0, _react.useCallback)(e => {
    setFieldDisplayedCustomLabel(e.target.value);
    const newCustomMetric = {
      ...customMetric,
      label: e.target.value
    };
    if (_snapshot_api.SnapshotCustomMetricInputRT.is(newCustomMetric)) debouncedOnChangeCustom(newCustomMetric);
  }, [customMetric, debouncedOnChangeCustom]);
  const availablefieldsOptions = metrics.map(m => {
    return {
      label: m.text,
      value: m.value
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "metricPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.metric.whenLabel', {
        defaultMessage: 'When'
      }),
      value: expressionDisplayValue,
      isActive: Boolean(popoverOpen || errors.metric && errors.metric.length > 0),
      onClick: () => {
        setPopoverOpen(true);
      },
      color: (_errors$metric = errors.metric) !== null && _errors$metric !== void 0 && _errors$metric.length ? 'danger' : 'success'
    }),
    isOpen: popoverOpen,
    closePopover: () => {
      setPopoverOpen(false);
    },
    anchorPosition: popupPosition !== null && popupPosition !== void 0 ? popupPosition : 'downRight',
    zIndex: 8000
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 620
    }
  }, /*#__PURE__*/_react.default.createElement(ClosablePopoverTitle, {
    onClose: () => setPopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alertFlyout.expression.metric.popoverTitle",
    defaultMessage: "Metric"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    buttonSize: "compressed",
    legend: "Metric type",
    options: [{
      id: 'metric-popover-default',
      label: 'Default metric'
    }, {
      id: 'metric-popover-custom',
      label: 'Custom metric'
    }],
    idSelected: customMetricTabOpen ? 'metric-popover-custom' : 'metric-popover-default',
    onChange: onChangeTab
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), customMetricTabOpen ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "infraMetricExpressionSelect",
    onChange: onAggregationChange,
    value: (customMetric === null || customMetric === void 0 ? void 0 : customMetric.aggregation) || 'avg',
    options: aggregationOptions,
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.infra.waffle.customMetrics.of', {
    defaultMessage: 'of'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.fieldPlaceholder', {
      defaultMessage: 'Select a field'
    }),
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: customMetric !== null && customMetric !== void 0 && customMetric.field ? [{
      label: customMetric.field
    }] : [],
    options: fieldOptions,
    onChange: onFieldChange,
    isClearable: false,
    isInvalid: errors.metric.length > 0
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.waffle.alerting.customMetrics.labelLabel', {
      defaultMessage: 'Metric name (optional)'
    }),
    display: "rowCompressed",
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.infra.waffle.alerting.customMetrics.helpText', {
      defaultMessage: 'Choose a name to help identify your custom metric. Defaults to "<function> of <field name>".',
      ignoreTag: true
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "infraMetricExpressionFieldText",
    name: "label",
    placeholder: _i18n.i18n.translate('xpack.infra.waffle.customMetrics.labelPlaceholder', {
      defaultMessage: 'Choose a name to appear in the "Metric" dropdown'
    }),
    value: fieldDisplayedCustomLabel,
    fullWidth: true,
    onChange: onLabelChange
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "actOf__metricContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    singleSelection: {
      asPlainText: true
    },
    "data-test-subj": "availablefieldsOptionsComboBox",
    isInvalid: errors.metric.length > 0,
    placeholder: firstFieldOption.text,
    options: availablefieldsOptions,
    noSuggestions: !availablefieldsOptions.length,
    selectedOptions: metric ? availablefieldsOptions.filter(a => a.value === metric.value) : [],
    renderOption: o => o.label,
    onChange: selectedOptions => {
      if (selectedOptions.length > 0) {
        onChange(selectedOptions[0].value);
        setSelectedOption(selectedOptions[0].value);
      } else {
        onChange();
      }
    }
  }))))));
};
exports.MetricExpression = MetricExpression;
const ClosablePopoverTitle = ({
  children,
  onClose
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraClosablePopoverTitleButton",
    iconType: "cross",
    color: "danger",
    "aria-label": _i18n.i18n.translate('xpack.infra.metrics.expressionItems.components.closablePopoverTitle.closeLabel', {
      defaultMessage: 'Close'
    }),
    onClick: () => onClose()
  }))));
};
exports.ClosablePopoverTitle = ClosablePopoverTitle;