"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.staticInventoryViewId = exports.staticInventoryViewAttributes = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const staticInventoryViewId = exports.staticInventoryViewId = '0';
const staticInventoryViewAttributes = exports.staticInventoryViewAttributes = {
  name: _i18n.i18n.translate('xpack.infra.savedView.defaultViewNameHosts', {
    defaultMessage: 'Default view'
  }),
  isDefault: false,
  isStatic: true,
  metric: {
    type: 'cpu'
  },
  groupBy: [],
  nodeType: 'host',
  view: 'map',
  customOptions: [],
  boundsOverride: {
    max: 1,
    min: 0
  },
  autoBounds: true,
  accountId: '',
  region: '',
  customMetrics: [],
  legend: {
    palette: 'cool',
    steps: 10,
    reverseColors: false
  },
  source: 'default',
  sort: {
    by: 'name',
    direction: 'desc'
  },
  timelineOpen: false,
  filterQuery: {
    kind: 'kuery',
    expression: ''
  },
  autoReload: false
};