"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUpdateMappingRoute = registerUpdateMappingRoute;
var _configSchema = require("@kbn/config-schema");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const paramsSchema = _configSchema.schema.object({
  indexName: _configSchema.schema.string()
});
function registerUpdateMappingRoute({
  router,
  lib: {
    handleEsError
  }
}) {
  router.put({
    path: (0, _.addBasePath)('/mapping/{indexName}'),
    validate: {
      body: _configSchema.schema.maybe(_configSchema.schema.object({}, {
        unknowns: 'allow'
      })),
      params: paramsSchema
    }
  }, async (context, request, response) => {
    const {
      client
    } = (await context.core).elasticsearch;
    const {
      indexName
    } = request.params;
    try {
      const responseBody = await client.asCurrentUser.indices.putMapping({
        properties: request.body,
        index: indexName
      });
      return response.ok({
        body: responseBody
      });
    } catch (error) {
      return handleEsError({
        error,
        response
      });
    }
  });
}