"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGetRoute = registerGetRoute;
var _configSchema = require("@kbn/config-schema");
var _server = require("@kbn/kibana-utils-plugin/server");
var _fetch_indices = require("../../../lib/fetch_indices");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerGetRoute({
  router,
  indexDataEnricher,
  lib: {
    handleEsError
  },
  config
}) {
  router.get({
    path: (0, _.addInternalBasePath)('/indices/{indexName}'),
    validate: {
      params: _configSchema.schema.object({
        indexName: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    const client = (await context.core).elasticsearch.client;
    const {
      indexName
    } = request.params;
    try {
      const indices = await (0, _fetch_indices.fetchIndices)({
        client,
        indexDataEnricher,
        indexNames: [indexName],
        config
      });
      if (indices.length !== 1) {
        return (0, _server.reportServerError)(response, new _server.KbnServerError(`Data for index ${indexName} was not found`, 400));
      }
      return response.ok({
        body: indices[0]
      });
    } catch (error) {
      return handleEsError({
        error,
        response
      });
    }
  });
}